/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.FilePerSplitHintSpec;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalInputSpec;

public class ExternalInputSpecSlicer
implements InputSpecSlicer {
    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return ((ExternalInputSpec)inputSpec).getInputSource().isSplittable();
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        ExternalInputSpec externalInputSpec = (ExternalInputSpec)inputSpec;
        if (externalInputSpec.getInputSource().isSplittable()) {
            return ExternalInputSpecSlicer.sliceSplittableInputSource(externalInputSpec, new StaticSplitHintSpec(maxNumSlices), maxNumSlices);
        }
        return ExternalInputSpecSlicer.sliceUnsplittableInputSource(externalInputSpec);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        ExternalInputSpec externalInputSpec = (ExternalInputSpec)inputSpec;
        if (externalInputSpec.getInputSource().isSplittable()) {
            return ExternalInputSpecSlicer.sliceSplittableInputSource(externalInputSpec, new DynamicSplitHintSpec(maxNumSlices, maxFilesPerSlice, maxBytesPerSlice), maxNumSlices);
        }
        return ExternalInputSpecSlicer.sliceUnsplittableInputSource(externalInputSpec);
    }

    private static List<InputSlice> sliceUnsplittableInputSource(ExternalInputSpec inputSpec) {
        return Collections.singletonList(new ExternalInputSlice(Collections.singletonList(inputSpec.getInputSource()), inputSpec.getInputFormat(), inputSpec.getSignature()));
    }

    private static List<InputSlice> sliceSplittableInputSource(ExternalInputSpec inputSpec, SplitHintSpec splitHintSpec, int maxNumSlices) {
        SplittableInputSource splittableInputSource = (SplittableInputSource)inputSpec.getInputSource();
        try {
            List splitList = splittableInputSource.createSplits(inputSpec.getInputFormat(), splitHintSpec).collect(Collectors.toList());
            ArrayList<InputSlice> assignments = new ArrayList<InputSlice>();
            if (splitList.size() <= maxNumSlices) {
                for (InputSplit split : splitList) {
                    assignments.add(ExternalInputSpecSlicer.splitsToSlice(inputSpec, Collections.singletonList(split)));
                }
            } else {
                List splitsList = SlicerUtils.makeSlicesStatic(splitList.iterator(), maxNumSlices);
                for (List<InputSplit<?>> list : splitsList) {
                    assignments.add(ExternalInputSpecSlicer.splitsToSlice(inputSpec, list));
                }
            }
            return assignments;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputSlice splitsToSlice(ExternalInputSpec spec, List<InputSplit<?>> splits) {
        try {
            SplittableInputSource splittableInputSource = (SplittableInputSource)spec.getInputSource();
            ArrayList<InputSource> subSources = new ArrayList<InputSource>();
            for (InputSplit<?> split : splits) {
                ((SplittableInputSource)splittableInputSource.withSplit(split)).createSplits(spec.getInputFormat(), (SplitHintSpec)FilePerSplitHintSpec.INSTANCE).map(subSplit -> splittableInputSource.withSplit(subSplit)).forEach(s -> subSources.add((InputSource)s));
            }
            if (subSources.isEmpty()) {
                return NilInputSlice.INSTANCE;
            }
            return new ExternalInputSlice(subSources, spec.getInputFormat(), spec.getSignature());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class DynamicSplitHintSpec
    implements SplitHintSpec {
        private final int maxNumSlices;
        private final int maxFilesPerSlice;
        private final long maxBytesPerSlice;

        public DynamicSplitHintSpec(int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
            this.maxNumSlices = maxNumSlices;
            this.maxFilesPerSlice = maxFilesPerSlice;
            this.maxBytesPerSlice = maxBytesPerSlice;
        }

        public <T> Iterator<List<T>> split(Iterator<T> inputIterator, Function<T, InputFileAttribute> inputAttributeExtractor) {
            return Iterators.filter(SlicerUtils.makeSlicesDynamic(inputIterator, item -> ((InputFileAttribute)inputAttributeExtractor.apply(item)).getWeightedSize(), this.maxNumSlices, this.maxFilesPerSlice, this.maxBytesPerSlice).iterator(), xs -> !xs.isEmpty());
        }
    }

    static class StaticSplitHintSpec
    implements SplitHintSpec {
        private final int maxNumSlices;

        public StaticSplitHintSpec(int maxNumSlices) {
            this.maxNumSlices = maxNumSlices;
        }

        public <T> Iterator<List<T>> split(Iterator<T> inputIterator, Function<T, InputFileAttribute> inputAttributeExtractor) {
            return Iterators.filter(SlicerUtils.makeSlicesStatic(inputIterator, item -> ((InputFileAttribute)inputAttributeExtractor.apply(item)).getSize(), this.maxNumSlices).iterator(), xs -> !xs.isEmpty());
        }
    }
}

