/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.msq.exec.SegmentLoadStatusFetcher;
import org.apache.druid.msq.exec.WorkerStats;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.msq.indexing.report.MSQSegmentReport;
import org.joda.time.DateTime;

public class MSQStatusReport {
    private final TaskState status;
    @Nullable
    private final MSQErrorReport errorReport;
    private final Collection<MSQErrorReport> warningReports;
    @Nullable
    private final DateTime startTime;
    private final long durationMs;
    private final Map<Integer, List<WorkerStats>> workerStats;
    private final int pendingTasks;
    private final int runningTasks;
    @Nullable
    private final SegmentLoadStatusFetcher.SegmentLoadWaiterStatus segmentLoadWaiterStatus;
    @Nullable
    private final MSQSegmentReport segmentReport;

    @JsonCreator
    public MSQStatusReport(@JsonProperty(value="status") TaskState status, @JsonProperty(value="errorReport") @Nullable MSQErrorReport errorReport, @JsonProperty(value="warnings") Collection<MSQErrorReport> warningReports, @JsonProperty(value="startTime") @Nullable DateTime startTime, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="workers") Map<Integer, List<WorkerStats>> workerStats, @JsonProperty(value="pendingTasks") int pendingTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="segmentLoadWaiterStatus") @Nullable SegmentLoadStatusFetcher.SegmentLoadWaiterStatus segmentLoadWaiterStatus, @JsonProperty(value="segmentReport") @Nullable MSQSegmentReport segmentReport) {
        this.status = (TaskState)Preconditions.checkNotNull((Object)status, (Object)"status");
        this.errorReport = errorReport;
        this.warningReports = warningReports != null ? warningReports : Collections.emptyList();
        this.startTime = startTime;
        this.durationMs = durationMs;
        this.workerStats = workerStats;
        this.pendingTasks = pendingTasks;
        this.runningTasks = runningTasks;
        this.segmentLoadWaiterStatus = segmentLoadWaiterStatus;
        this.segmentReport = segmentReport;
    }

    @JsonProperty
    public TaskState getStatus() {
        return this.status;
    }

    @Nullable
    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MSQErrorReport getErrorReport() {
        return this.errorReport;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Collection<MSQErrorReport> getWarningReports() {
        return this.warningReports;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public int getPendingTasks() {
        return this.pendingTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public long getDurationMs() {
        return this.durationMs;
    }

    @JsonProperty(value="workers")
    public Map<Integer, List<WorkerStats>> getWorkerStats() {
        return this.workerStats;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SegmentLoadStatusFetcher.SegmentLoadWaiterStatus getSegmentLoadWaiterStatus() {
        return this.segmentLoadWaiterStatus;
    }

    @JsonProperty(value="segmentReport")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public MSQSegmentReport getSegmentReport() {
        return this.segmentReport;
    }

    public TaskStatus toTaskStatus(String taskId) {
        if (this.status == TaskState.SUCCESS) {
            return TaskStatus.success((String)taskId);
        }
        return TaskStatus.failure((String)taskId, (String)MSQFaultUtils.generateMessageWithErrorCode(this.errorReport.getFault()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQStatusReport that = (MSQStatusReport)o;
        return this.durationMs == that.durationMs && this.status == that.status && Objects.equals(this.errorReport, that.errorReport) && Objects.equals(this.warningReports, that.warningReports) && Objects.equals(this.startTime, that.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.errorReport, this.warningReports, this.startTime, this.durationMs);
    }

    public String toString() {
        return "MSQStatusReport{status=" + this.status + ", errorReport=" + this.errorReport + ", warningReports=" + this.warningReports + ", startTime=" + this.startTime + ", durationMs=" + this.durationMs + '}';
    }
}

