/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="InvalidNullByte")
public class InvalidNullByteFault
extends BaseMSQFault {
    static final String CODE = "InvalidNullByte";
    private final String source;
    private final Integer rowNumber;
    private final String column;
    private final String value;
    private final Integer position;

    @JsonCreator
    public InvalidNullByteFault(@Nullable @JsonProperty(value="source") String source, @Nullable @JsonProperty(value="rowNumber") Integer rowNumber, @Nullable @JsonProperty(value="column") String column, @Nullable @JsonProperty(value="value") String value, @Nullable @JsonProperty(value="position") Integer position) {
        super(CODE, "Invalid null byte at source[%s], rowNumber[%d], column[%s], value[%s], position[%d]. Consider sanitizing the input string column using \"REPLACE(\"%s\", U&'\\0000', '') AS %s\" or setting 'removeNullBytes' to true in the query context.", source, rowNumber, column, value, position, column, column);
        this.source = source;
        this.rowNumber = rowNumber;
        this.column = column;
        this.value = value;
        this.position = position;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSource() {
        return this.source;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getRowNumber() {
        return this.rowNumber;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValue() {
        return this.value;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getColumn() {
        return this.column;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvalidNullByteFault that = (InvalidNullByteFault)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.rowNumber, that.rowNumber) && Objects.equals(this.column, that.column) && Objects.equals(this.value, that.value) && Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.rowNumber, this.column, this.value, this.position);
    }
}

