/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.cleaner;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.duty.DutySchedule;
import org.apache.druid.indexing.overlord.duty.OverlordDuty;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.cleaner.DurableStorageCleanerConfig;
import org.apache.druid.storage.StorageConnector;

public class DurableStorageCleaner
implements OverlordDuty {
    private static final Logger LOG = new Logger(DurableStorageCleaner.class);
    private final DurableStorageCleanerConfig config;
    private final StorageConnector storageConnector;
    private final Provider<TaskMaster> taskMasterProvider;

    @Inject
    public DurableStorageCleaner(DurableStorageCleanerConfig config, @MultiStageQuery StorageConnector storageConnector, @JacksonInject Provider<TaskMaster> taskMasterProvider) {
        this.config = config;
        this.storageConnector = storageConnector;
        this.taskMasterProvider = taskMasterProvider;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public void run() throws Exception {
        Optional taskRunnerOptional = ((TaskMaster)this.taskMasterProvider.get()).getTaskRunner();
        if (!taskRunnerOptional.isPresent()) {
            LOG.info("DurableStorageCleaner not running since the node is not the leader", new Object[0]);
            return;
        }
        LOG.info("Running DurableStorageCleaner", new Object[0]);
        TaskRunner taskRunner = (TaskRunner)taskRunnerOptional.get();
        Iterator allFiles = this.storageConnector.listDir("");
        Set runningTaskIds = taskRunner.getRunningTasks().stream().map(TaskRunnerWorkItem::getTaskId).map(DurableStorageUtils::getControllerDirectory).collect(Collectors.toSet());
        Set knownTaskIds = taskRunner.getKnownTasks().stream().map(TaskRunnerWorkItem::getTaskId).map(DurableStorageUtils::getControllerDirectory).collect(Collectors.toSet());
        HashSet<String> filesToRemove = new HashSet<String>();
        while (allFiles.hasNext()) {
            String currentFile = (String)allFiles.next();
            String nextDirName = DurableStorageUtils.getNextDirNameWithPrefixFromPath((String)currentFile);
            if (nextDirName == null || nextDirName.isEmpty() || runningTaskIds.contains(nextDirName) || "query-results".equals(nextDirName) && DurableStorageUtils.isQueryResultFileActive((String)currentFile, knownTaskIds)) continue;
            filesToRemove.add(currentFile);
        }
        if (filesToRemove.isEmpty()) {
            LOG.info("There are no leftover directories to delete.", new Object[0]);
        } else {
            LOG.info("Removing [%d] files which are not associated with any MSQ task.", new Object[]{filesToRemove.size()});
            LOG.debug("Files to remove:\n[%s]\n", new Object[]{filesToRemove});
            this.storageConnector.deleteFiles(filesToRemove);
        }
    }

    public DutySchedule getSchedule() {
        long delayMillis = this.config.getDelaySeconds() * 1000L;
        return new DutySchedule(delayMillis, delayMillis);
    }
}

