/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import java.io.IOException;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.segment.RowAdapter;

public class CountableInputSourceReader
implements InputSourceReader {
    private final InputSourceReader inputSourceReader;
    private final ChannelCounters channelCounters;

    public CountableInputSourceReader(InputSourceReader inputSourceReader, ChannelCounters channelCounters) {
        this.inputSourceReader = inputSourceReader;
        this.channelCounters = channelCounters;
    }

    public CloseableIterator<InputRow> read(InputStats inputStats) throws IOException {
        return this.inputSourceReader.read(inputStats).map(inputRow -> {
            this.channelCounters.incrementRowCount();
            return inputRow;
        });
    }

    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        return this.inputSourceReader.sample();
    }

    public RowAdapter<InputRow> rowAdapter() {
        return this.inputSourceReader.rowAdapter();
    }
}

