/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.util.MSQTaskQueryMakerUtils;
import org.joda.time.DateTime;

public class DartQueryInfo {
    private final String sqlQueryId;
    private final String dartQueryId;
    private final String sql;
    private final String controllerHost;
    private final String authenticator;
    private final String identity;
    private final DateTime startTime;
    private final String state;

    @JsonCreator
    public DartQueryInfo(@JsonProperty(value="sqlQueryId") String sqlQueryId, @JsonProperty(value="dartQueryId") String dartQueryId, @JsonProperty(value="sql") String sql, @JsonProperty(value="controllerHost") String controllerHost, @JsonProperty(value="authenticator") String authenticator, @JsonProperty(value="identity") String identity, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="state") String state) {
        this.sqlQueryId = (String)Preconditions.checkNotNull((Object)sqlQueryId, (Object)"sqlQueryId");
        this.dartQueryId = (String)Preconditions.checkNotNull((Object)dartQueryId, (Object)"dartQueryId");
        this.sql = sql;
        this.controllerHost = controllerHost;
        this.authenticator = authenticator;
        this.identity = identity;
        this.startTime = startTime;
        this.state = state;
    }

    public static DartQueryInfo fromControllerHolder(ControllerHolder holder) {
        return new DartQueryInfo(holder.getSqlQueryId(), holder.getController().queryId(), MSQTaskQueryMakerUtils.maskSensitiveJsonKeys(holder.getSql()), holder.getControllerHost(), holder.getAuthenticationResult().getAuthenticatedBy(), holder.getAuthenticationResult().getIdentity(), holder.getStartTime(), holder.getState().toString());
    }

    @JsonProperty
    public String getSqlQueryId() {
        return this.sqlQueryId;
    }

    @JsonProperty
    public String getDartQueryId() {
        return this.dartQueryId;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSql() {
        return this.sql;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getControllerHost() {
        return this.controllerHost;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAuthenticator() {
        return this.authenticator;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdentity() {
        return this.identity;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    public DartQueryInfo withoutAuthenticationResult() {
        return new DartQueryInfo(this.sqlQueryId, this.dartQueryId, this.sql, this.controllerHost, null, null, this.startTime, this.state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartQueryInfo that = (DartQueryInfo)o;
        return Objects.equals(this.sqlQueryId, that.sqlQueryId) && Objects.equals(this.dartQueryId, that.dartQueryId) && Objects.equals(this.sql, that.sql) && Objects.equals(this.controllerHost, that.controllerHost) && Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.identity, that.identity) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.sqlQueryId, this.dartQueryId, this.sql, this.controllerHost, this.authenticator, this.identity, this.startTime, this.state);
    }

    public String toString() {
        return "DartQueryInfo{sqlQueryId='" + this.sqlQueryId + '\'' + ", dartQueryId='" + this.dartQueryId + '\'' + ", sql='" + this.sql + '\'' + ", controllerHost='" + this.controllerHost + '\'' + ", authenticator='" + this.authenticator + '\'' + ", identity='" + this.identity + '\'' + ", startTime=" + this.startTime + ", state='" + this.state + '\'' + '}';
    }
}

