/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.google.inject.Binder;
import com.google.inject.Provides;
import org.apache.druid.common.aws.AWSClientConfig;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.common.aws.AWSCredentialsUtils;
import org.apache.druid.common.aws.AWSEndpointConfig;
import org.apache.druid.common.aws.AWSProxyConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;

public class AWSModule
implements DruidModule {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3", AWSCredentialsConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3", AWSClientConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3.proxy", AWSProxyConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3.endpoint", AWSEndpointConfig.class);
    }

    @Provides
    @LazySingleton
    public AWSCredentialsProvider getAWSCredentialsProvider(AWSCredentialsConfig config) {
        return AWSCredentialsUtils.defaultAWSCredentialsProviderChain(config);
    }

    @Provides
    @LazySingleton
    public AmazonEC2 getEc2Client(AWSCredentialsProvider credentials) {
        return new AmazonEC2Client(credentials);
    }
}

