/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTransitGatewayRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TransitGatewayRequestOptions;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTransitGatewayRequestMarshaller
implements Marshaller<Request<CreateTransitGatewayRequest>, CreateTransitGatewayRequest> {
    public Request<CreateTransitGatewayRequest> marshall(CreateTransitGatewayRequest createTransitGatewayRequest) {
        SdkInternalList createTransitGatewayRequestTagSpecificationsList;
        TransitGatewayRequestOptions options;
        if (createTransitGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTransitGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTransitGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTransitGatewayRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createTransitGatewayRequest.getDescription()));
        }
        if ((options = createTransitGatewayRequest.getOptions()) != null) {
            SdkInternalList transitGatewayRequestOptionsTransitGatewayCidrBlocksList;
            if (options.getAmazonSideAsn() != null) {
                request.addParameter("Options.AmazonSideAsn", StringUtils.fromLong((Long)options.getAmazonSideAsn()));
            }
            if (options.getAutoAcceptSharedAttachments() != null) {
                request.addParameter("Options.AutoAcceptSharedAttachments", StringUtils.fromString((String)options.getAutoAcceptSharedAttachments()));
            }
            if (options.getDefaultRouteTableAssociation() != null) {
                request.addParameter("Options.DefaultRouteTableAssociation", StringUtils.fromString((String)options.getDefaultRouteTableAssociation()));
            }
            if (options.getDefaultRouteTablePropagation() != null) {
                request.addParameter("Options.DefaultRouteTablePropagation", StringUtils.fromString((String)options.getDefaultRouteTablePropagation()));
            }
            if (options.getVpnEcmpSupport() != null) {
                request.addParameter("Options.VpnEcmpSupport", StringUtils.fromString((String)options.getVpnEcmpSupport()));
            }
            if (options.getDnsSupport() != null) {
                request.addParameter("Options.DnsSupport", StringUtils.fromString((String)options.getDnsSupport()));
            }
            if (options.getSecurityGroupReferencingSupport() != null) {
                request.addParameter("Options.SecurityGroupReferencingSupport", StringUtils.fromString((String)options.getSecurityGroupReferencingSupport()));
            }
            if (options.getMulticastSupport() != null) {
                request.addParameter("Options.MulticastSupport", StringUtils.fromString((String)options.getMulticastSupport()));
            }
            if (!(transitGatewayRequestOptionsTransitGatewayCidrBlocksList = (SdkInternalList)options.getTransitGatewayCidrBlocks()).isEmpty() || !transitGatewayRequestOptionsTransitGatewayCidrBlocksList.isAutoConstruct()) {
                int transitGatewayCidrBlocksListIndex = 1;
                for (String transitGatewayRequestOptionsTransitGatewayCidrBlocksListValue : transitGatewayRequestOptionsTransitGatewayCidrBlocksList) {
                    if (transitGatewayRequestOptionsTransitGatewayCidrBlocksListValue != null) {
                        request.addParameter("Options.TransitGatewayCidrBlocks." + transitGatewayCidrBlocksListIndex, StringUtils.fromString((String)transitGatewayRequestOptionsTransitGatewayCidrBlocksListValue));
                    }
                    ++transitGatewayCidrBlocksListIndex;
                }
            }
        }
        if (!(createTransitGatewayRequestTagSpecificationsList = (SdkInternalList)createTransitGatewayRequest.getTagSpecifications()).isEmpty() || !createTransitGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createTransitGatewayRequestTagSpecificationsListValue : createTransitGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createTransitGatewayRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createTransitGatewayRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createTransitGatewayRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

