/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CreateIntegrationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceArn;
    private String targetArn;
    private String integrationName;
    private String kMSKeyId;
    private SdkInternalMap<String, String> additionalEncryptionContext;
    private SdkInternalList<Tag> tags;

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public CreateIntegrationRequest withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public CreateIntegrationRequest withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    public String getIntegrationName() {
        return this.integrationName;
    }

    public CreateIntegrationRequest withIntegrationName(String integrationName) {
        this.setIntegrationName(integrationName);
        return this;
    }

    public void setKMSKeyId(String kMSKeyId) {
        this.kMSKeyId = kMSKeyId;
    }

    public String getKMSKeyId() {
        return this.kMSKeyId;
    }

    public CreateIntegrationRequest withKMSKeyId(String kMSKeyId) {
        this.setKMSKeyId(kMSKeyId);
        return this;
    }

    public Map<String, String> getAdditionalEncryptionContext() {
        if (this.additionalEncryptionContext == null) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext == null ? null : new SdkInternalMap(additionalEncryptionContext);
    }

    public CreateIntegrationRequest withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public CreateIntegrationRequest addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        if (this.additionalEncryptionContext.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put((Object)key, (Object)value);
        return this;
    }

    public CreateIntegrationRequest clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateIntegrationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateIntegrationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getIntegrationName() != null) {
            sb.append("IntegrationName: ").append(this.getIntegrationName()).append(",");
        }
        if (this.getKMSKeyId() != null) {
            sb.append("KMSKeyId: ").append(this.getKMSKeyId()).append(",");
        }
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationRequest)) {
            return false;
        }
        CreateIntegrationRequest other = (CreateIntegrationRequest)obj;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getIntegrationName() == null ^ this.getIntegrationName() == null) {
            return false;
        }
        if (other.getIntegrationName() != null && !other.getIntegrationName().equals(this.getIntegrationName())) {
            return false;
        }
        if (other.getKMSKeyId() == null ^ this.getKMSKeyId() == null) {
            return false;
        }
        if (other.getKMSKeyId() != null && !other.getKMSKeyId().equals(this.getKMSKeyId())) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationName() == null ? 0 : this.getIntegrationName().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyId() == null ? 0 : this.getKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateIntegrationRequest clone() {
        return (CreateIntegrationRequest)super.clone();
    }
}

