/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;

public class Subtotals {
    private final List<IntList> subtotals;

    Subtotals(List<IntList> subtotals) {
        this.subtotals = subtotals;
    }

    public List<IntList> getSubtotals() {
        return this.subtotals;
    }

    @Nullable
    public List<List<String>> toSubtotalsSpec(List<DimensionSpec> dimensions) {
        if (this.hasEffect(dimensions)) {
            return this.subtotals.stream().map(subtotalInts -> {
                ArrayList<String> subtotalDimensionNames = new ArrayList<String>();
                IntListIterator intListIterator = subtotalInts.iterator();
                while (intListIterator.hasNext()) {
                    int dimIndex = (Integer)intListIterator.next();
                    subtotalDimensionNames.add(((DimensionSpec)dimensions.get(dimIndex)).getOutputName());
                }
                return subtotalDimensionNames;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public boolean hasEffect(List<DimensionSpec> dimensionSpecs) {
        return !this.subtotals.isEmpty() && (this.subtotals.size() != 1 || this.subtotals.get(0).size() != dimensionSpecs.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subtotals subtotals1 = (Subtotals)o;
        return this.subtotals.equals(subtotals1.subtotals);
    }

    public int hashCode() {
        return Objects.hash(this.subtotals);
    }

    public String toString() {
        return "Subtotals{subtotals=" + this.subtotals + '}';
    }
}

