/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.DruidVolcanoCost;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlParserImplFactory;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidConformance;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.DruidRexExecutor;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerHook;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletTable;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.hook.DruidHook;
import org.apache.druid.sql.hook.DruidHookDispatcher;

public class PlannerFactory
extends PlannerToolbox {
    static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setQuoting(Quoting.DOUBLE_QUOTE).setConformance((SqlConformance)DruidConformance.instance()).setParserFactory((SqlParserImplFactory)new DruidSqlParserImplFactory()).build();

    @Inject
    public PlannerFactory(DruidSchemaCatalog rootSchema, DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper, @Json ObjectMapper jsonMapper, @DruidSchemaName String druidSchemaName, CalciteRulesManager calciteRuleManager, JoinableFactoryWrapper joinableFactoryWrapper, CatalogResolver catalog, AuthConfig authConfig, DruidHookDispatcher hookDispatcher) {
        super(operatorTable, macroTable, jsonMapper, plannerConfig, rootSchema, joinableFactoryWrapper, catalog, druidSchemaName, calciteRuleManager, authorizerMapper, authConfig, hookDispatcher);
    }

    public DruidPlanner createPlanner(SqlEngine engine, String sql, Map<String, Object> queryContext, PlannerHook hook) {
        PlannerContext context = PlannerContext.create(this, sql, engine, queryContext, hook);
        context.dispatchHook(DruidHook.SQL, sql);
        return new DruidPlanner(this.buildFrameworkConfig(context), context, engine, hook);
    }

    @VisibleForTesting
    public DruidPlanner createPlannerForTesting(SqlEngine engine, String sql, Map<String, Object> queryContext) {
        DruidPlanner thePlanner = this.createPlanner(engine, sql, queryContext, null);
        thePlanner.getPlannerContext().setAuthenticationResult(NoopEscalator.getInstance().createEscalatedAuthenticationResult());
        thePlanner.validate();
        thePlanner.authorize(ra -> Access.OK, (Set<ResourceAction>)ImmutableSet.of());
        return thePlanner;
    }

    public AuthorizerMapper getAuthorizerMapper() {
        return this.authorizerMapper;
    }

    private FrameworkConfig buildFrameworkConfig(final PlannerContext plannerContext) {
        SqlToRelConverter.Config sqlToRelConverterConfig = SqlToRelConverter.config().withExpand(false).withDecorrelationEnabled(false).withTrimUnusedFields(false).withInSubQueryThreshold(plannerContext.queryContext().getInSubQueryThreshold());
        Frameworks.ConfigBuilder frameworkConfigBuilder = Frameworks.newConfigBuilder().parserConfig(PARSER_CONFIG).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).convertletTable((SqlRexConvertletTable)new DruidConvertletTable(plannerContext)).operatorTable((SqlOperatorTable)this.operatorTable).programs(this.calciteRuleManager.programs(plannerContext)).executor((RexExecutor)new DruidRexExecutor(plannerContext)).typeSystem((RelDataTypeSystem)DruidTypeSystem.INSTANCE).defaultSchema(this.rootSchema.getSubSchema(this.druidSchemaName)).sqlToRelConverterConfig(sqlToRelConverterConfig).context(new Context(){

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.equals(CalciteConnectionConfig.class)) {
                    Properties props = new Properties();
                    return (C)new CalciteConnectionConfigImpl(props){

                        public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
                            return (T)DruidTypeSystem.INSTANCE;
                        }

                        public SqlConformance conformance() {
                            return DruidConformance.instance();
                        }
                    };
                }
                if (aClass.equals(PlannerContext.class)) {
                    return (C)plannerContext;
                }
                return null;
            }
        });
        if ("DECOUPLED".equals(this.plannerConfig().getNativeQuerySqlPlanningMode())) {
            frameworkConfigBuilder.costFactory((RelOptCostFactory)new DruidVolcanoCost.Factory());
        }
        return frameworkConfigBuilder.build();
    }

    static class DruidCalciteConnectionConfigImpl
    extends CalciteConnectionConfigImpl {
        public DruidCalciteConnectionConfigImpl(Properties properties) {
            super(properties);
        }

        public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
            return (T)DruidTypeSystem.INSTANCE;
        }

        public SqlConformance conformance() {
            return DruidConformance.instance();
        }

        public CalciteConnectionConfigImpl set(CalciteConnectionProperty property, String value) {
            Properties newProperties = (Properties)this.properties.clone();
            newProperties.setProperty(property.camelName(), value);
            return new DruidCalciteConnectionConfigImpl(newProperties);
        }
    }
}

