/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import org.apache.druid.java.util.common.IAE;

public enum JoinAlgorithm {
    BROADCAST("broadcast"){

        @Override
        public boolean requiresSubquery() {
            return false;
        }
    }
    ,
    SORT_MERGE("sortMerge"){

        @Override
        public boolean requiresSubquery() {
            return true;
        }
    };

    private final String id;

    private JoinAlgorithm(String id) {
        this.id = id;
    }

    @JsonCreator
    public static JoinAlgorithm fromString(String id) {
        for (JoinAlgorithm value : JoinAlgorithm.values()) {
            if (!value.id.equals(id)) continue;
            return value;
        }
        throw new IAE("No such join algorithm [%s]. Supported values are: %s", new Object[]{id, Arrays.toString((Object[])JoinAlgorithm.values())});
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    public abstract boolean requiresSubquery();

    public String toString() {
        return this.id;
    }
}

