/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.parser.ExternalDestinationSqlIdentifier;
import org.apache.druid.sql.calcite.planner.ExplainAttributes;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.QueryHandler;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.destination.ExportDestination;
import org.apache.druid.sql.destination.IngestDestination;
import org.apache.druid.sql.destination.TableDestination;
import org.apache.druid.storage.ExportStorageProvider;

public abstract class IngestHandler
extends QueryHandler {
    protected Granularity ingestionGranularity;
    protected IngestDestination targetDatasource;
    private SqlNode validatedQueryNode;

    IngestHandler(SqlStatementHandler.HandlerContext handlerContext, SqlExplain explain) {
        super(handlerContext, explain);
    }

    protected static SqlNode convertSourceQuery(DruidSqlIngest sqlNode) {
        SqlNode query = sqlNode.getSource();
        if (query instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
            SqlNodeList orderByList = sqlOrderBy.orderList;
            if (orderByList != null && !orderByList.equals((Object)SqlNodeList.EMPTY)) {
                throw InvalidSqlInput.exception((String)"Cannot use an ORDER BY clause on a Query of type [%s], use CLUSTERED BY instead", (Object[])new Object[]{sqlNode.getOperator().getName()});
            }
        }
        if (sqlNode.getClusteredBy() != null) {
            query = DruidSqlParserUtils.convertClusterByToOrderBy(query, sqlNode.getClusteredBy());
        }
        if (!query.isA((Set)SqlKind.QUERY)) {
            throw InvalidSqlInput.exception((String)"Unexpected SQL statement type [%s], expected it to be a QUERY", (Object[])new Object[]{query.getKind()});
        }
        return query;
    }

    protected String operationName() {
        return this.ingestNode().getOperator().getName();
    }

    protected abstract DruidSqlIngest ingestNode();

    private void validateExport() {
        if (!this.handlerContext.plannerContext().featureAvailable(EngineFeature.WRITE_EXTERNAL_DATA)) {
            throw InvalidSqlInput.exception((String)"Writing to external sources are not supported by requested SQL engine [%s], consider using MSQ.", (Object[])new Object[]{this.handlerContext.engine().name()});
        }
        if (this.ingestNode().getPartitionedBy() != null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Export statements do not support a PARTITIONED BY or CLUSTERED BY clause.", new Object[0]);
        }
        SqlIdentifier exportFileFormat = this.ingestNode().getExportFileFormat();
        if (exportFileFormat == null) {
            throw InvalidSqlInput.exception((String)"Exporting rows into an EXTERN destination requires an AS clause to specify the format, but none was found.", (Object[])new Object[]{this.operationName()});
        }
        this.handlerContext.plannerContext().queryContextMap().put("__exportFileFormat", exportFileFormat.toString());
    }

    @Override
    public void validate() {
        if (this.ingestNode().getTargetTable() instanceof ExternalDestinationSqlIdentifier) {
            this.validateExport();
        } else if (this.ingestNode().getExportFileFormat() != null) {
            throw InvalidSqlInput.exception((String)"The AS <format> clause should only be specified while exporting rows into an EXTERN destination.", (Object[])new Object[]{this.operationName()});
        }
        if (this.handlerContext.queryContextMap().get("sqlOuterLimit") != null) {
            throw InvalidSqlInput.exception((String)"Context parameter [%s] cannot be provided on operator [%s]", (Object[])new Object[]{"sqlOuterLimit", this.operationName()});
        }
        DruidSqlIngest ingestNode = this.ingestNode();
        DruidSqlIngest validatedNode = (DruidSqlIngest)this.validate((SqlNode)ingestNode);
        this.validatedQueryNode = validatedNode.getSource();
        String effectiveGranularity = (String)this.handlerContext.queryContextMap().get("sqlInsertSegmentGranularity");
        try {
            this.ingestionGranularity = effectiveGranularity != null ? (Granularity)this.handlerContext.jsonMapper().readValue(effectiveGranularity, Granularity.class) : null;
        }
        catch (JsonProcessingException e) {
            throw InvalidSqlInput.exception((Throwable)e, (String)"Invalid partition granularity [%s]", (Object[])new Object[]{effectiveGranularity});
        }
        this.targetDatasource = this.validateAndGetDataSourceForIngest();
    }

    @Override
    protected SqlNode validatedQueryNode() {
        return this.validatedQueryNode;
    }

    @Override
    protected RelDataType returnedRowType() {
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        return this.handlerContext.engine().resultTypeForInsert(typeFactory, this.rootQueryRel.validatedRowType, this.handlerContext.queryContextMap());
    }

    private IngestDestination validateAndGetDataSourceForIngest() {
        IngestDestination dataSource;
        DruidSqlIngest insert = this.ingestNode();
        SqlIdentifier tableIdentifier = (SqlIdentifier)insert.getTargetTable();
        if (tableIdentifier instanceof ExternalDestinationSqlIdentifier) {
            ExternalDestinationSqlIdentifier externalDestination = (ExternalDestinationSqlIdentifier)tableIdentifier;
            ExportStorageProvider storageProvider = externalDestination.toExportStorageProvider(this.handlerContext.jsonMapper());
            dataSource = new ExportDestination(storageProvider);
            this.resourceActions.add(new ResourceAction(new Resource(externalDestination.getDestinationType(), "EXTERNAL"), Action.WRITE));
        } else if (tableIdentifier.names.size() == 1) {
            String tableName = (String)Iterables.getOnlyElement((Iterable)tableIdentifier.names);
            IdUtils.validateId((String)"table", (String)tableName);
            dataSource = new TableDestination(tableName);
            this.resourceActions.add(new ResourceAction(new Resource(tableName, "DATASOURCE"), Action.WRITE));
        } else {
            String defaultSchemaName = (String)Iterables.getOnlyElement((Iterable)CalciteSchema.from((SchemaPlus)this.handlerContext.defaultSchema()).path(null));
            if (tableIdentifier.names.size() == 2 && defaultSchemaName.equals(tableIdentifier.names.get(0))) {
                String tableName = (String)tableIdentifier.names.get(1);
                IdUtils.validateId((String)"table", (String)tableName);
                dataSource = new TableDestination(tableName);
                this.resourceActions.add(new ResourceAction(new Resource(tableName, "DATASOURCE"), Action.WRITE));
            } else {
                throw InvalidSqlInput.exception((String)"Table [%s] does not support operation [%s] because it is not a Druid datasource", (Object[])new Object[]{tableIdentifier, this.operationName()});
            }
        }
        return dataSource;
    }

    @Override
    protected PlannerResult planForDruid() throws ValidationException {
        return this.planWithDruidConvention();
    }

    @Override
    protected QueryMaker buildQueryMaker(RelRoot rootQueryRel) throws ValidationException {
        return this.handlerContext.engine().buildQueryMakerForInsert(this.targetDatasource, rootQueryRel, this.handlerContext.plannerContext());
    }

    protected static class ReplaceHandler
    extends IngestHandler {
        private final DruidSqlReplace sqlNode;
        private String replaceIntervals;

        public ReplaceHandler(SqlStatementHandler.HandlerContext handlerContext, DruidSqlReplace sqlNode, SqlExplain explain) {
            super(handlerContext, explain);
            this.sqlNode = ReplaceHandler.convertQuery(sqlNode);
            handlerContext.hook().captureInsert(sqlNode);
        }

        protected static DruidSqlReplace convertQuery(DruidSqlReplace sqlNode) {
            SqlNode query = ReplaceHandler.convertSourceQuery(sqlNode);
            return DruidSqlReplace.create(new SqlInsert(sqlNode.getParserPosition(), (SqlNodeList)sqlNode.getOperandList().get(0), sqlNode.getOperandList().get(1), query, (SqlNodeList)sqlNode.getOperandList().get(3)), sqlNode.getPartitionedBy(), sqlNode.getClusteredBy(), sqlNode.getExportFileFormat(), sqlNode.getReplaceTimeQuery());
        }

        @Override
        protected DruidSqlIngest ingestNode() {
            return this.sqlNode;
        }

        @Override
        public void validate() {
            if (this.ingestNode().getTargetTable() instanceof ExternalDestinationSqlIdentifier) {
                throw InvalidSqlInput.exception((String)"REPLACE operations do no support EXTERN destinations. Use INSERT statements to write to an external destination.", (Object[])new Object[0]);
            }
            if (!this.handlerContext.plannerContext().featureAvailable(EngineFeature.CAN_REPLACE)) {
                throw InvalidSqlInput.exception((String)"REPLACE operations are not supported by the requested SQL engine [%s].  Consider using MSQ.", (Object[])new Object[]{this.handlerContext.engine().name()});
            }
            SqlNode replaceTimeQuery = this.sqlNode.getReplaceTimeQuery();
            if (replaceTimeQuery == null) {
                throw InvalidSqlInput.exception((String)"Missing time chunk information in OVERWRITE clause for REPLACE. Use OVERWRITE WHERE <__time based condition> or OVERWRITE ALL to overwrite the entire table.", (Object[])new Object[0]);
            }
            super.validate();
            List<String> replaceIntervalsList = DruidSqlParserUtils.validateQueryAndConvertToIntervals(replaceTimeQuery, this.ingestionGranularity, this.handlerContext.timeZone());
            if (replaceIntervalsList != null) {
                this.replaceIntervals = String.join((CharSequence)",", replaceIntervalsList);
                this.handlerContext.queryContextMap().put("sqlReplaceTimeChunks", this.replaceIntervals);
            }
        }

        @Override
        public ExplainAttributes explainAttributes() {
            return new ExplainAttributes(DruidSqlReplace.OPERATOR.getName(), this.targetDatasource.getDestinationName(), this.ingestionGranularity, DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns(this.sqlNode.getClusteredBy(), (List<Map.Entry<Integer, String>>)this.rootQueryRel.fields), this.replaceIntervals);
        }
    }

    protected static class InsertHandler
    extends IngestHandler {
        private final DruidSqlInsert sqlNode;

        public InsertHandler(SqlStatementHandler.HandlerContext handlerContext, DruidSqlInsert sqlNode, SqlExplain explain) {
            super(handlerContext, explain);
            this.sqlNode = InsertHandler.convertQuery(sqlNode);
            handlerContext.hook().captureInsert(sqlNode);
        }

        protected static DruidSqlInsert convertQuery(DruidSqlIngest sqlNode) {
            SqlNode query = InsertHandler.convertSourceQuery(sqlNode);
            return DruidSqlInsert.create(new SqlInsert(sqlNode.getParserPosition(), (SqlNodeList)sqlNode.getOperandList().get(0), sqlNode.getOperandList().get(1), query, (SqlNodeList)sqlNode.getOperandList().get(3)), sqlNode.getPartitionedBy(), sqlNode.getClusteredBy(), sqlNode.getExportFileFormat());
        }

        @Override
        protected DruidSqlIngest ingestNode() {
            return this.sqlNode;
        }

        @Override
        public void validate() {
            if (!this.handlerContext.plannerContext().featureAvailable(EngineFeature.CAN_INSERT)) {
                throw InvalidSqlInput.exception((String)"INSERT operations are not supported by requested SQL engine [%s], consider using MSQ.", (Object[])new Object[]{this.handlerContext.engine().name()});
            }
            super.validate();
        }

        @Override
        public ExplainAttributes explainAttributes() {
            return new ExplainAttributes(DruidSqlInsert.OPERATOR.getName(), this.targetDatasource.getDestinationName(), this.ingestionGranularity, DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns(this.sqlNode.getClusteredBy(), (List<Map.Entry<Integer, String>>)this.rootQueryRel.fields), null);
        }
    }
}

