/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.ApiFutureUtils;
import com.google.cloud.storage.AsyncAppendingQueue;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BufferHandlePool;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.MetadataField;
import com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.storage.ParallelCompositeUploadException;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ParallelCompositeUploadWritableByteChannel
implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
    private static final MetadataField<String> FINAL_OBJECT_NAME = MetadataField.forString("pcu_finalObjectName");
    private static final MetadataField<MetadataField.PartRange> PART_INDEX = MetadataField.forPartRange("pcu_partIndex");
    private static final MetadataField<Long> OBJECT_OFFSET = MetadataField.forLong("pcu_objectOffset");
    private static final Comparator<BlobInfo> comparator = Comparator.comparing(PART_INDEX::readFrom, MetadataField.PartRange.COMP);
    private static final Predicate<UnifiedOpts.ObjectTargetOpt> TO_EXCLUDE_FROM_PARTS;
    private static final UnifiedOpts.Opts<UnifiedOpts.GenerationMatch> DOES_NOT_EXIST;
    private final BufferHandlePool bufferPool;
    private final Executor exec;
    private final ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy;
    private final ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy partCleanupStrategy;
    private final int maxElementsPerCompact;
    private final SettableApiFuture<BlobInfo> finalObject;
    private final StorageInternal storage;
    private final BlobInfo ultimateObject;
    private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts;
    private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> partOpts;
    private final UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> srcOpts;
    private final AsyncAppendingQueue<BlobInfo> queue;
    private final FailureForwarder failureForwarder;
    private final List<ApiFuture<BlobInfo>> pendingParts;
    private final List<BlobId> successfulParts;
    private final Hasher cumulativeHasher;
    private boolean open;
    private long totalObjectOffset;
    private BufferHandlePool.PooledBuffer current;

    ParallelCompositeUploadWritableByteChannel(BufferHandlePool bufferPool, Executor exec, ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy, ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy partCleanupStrategy, int maxElementsPerCompact, SettableApiFuture<BlobInfo> finalObject, StorageInternal storage, BlobInfo ultimateObject, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        this.bufferPool = bufferPool;
        this.exec = exec;
        this.partNamingStrategy = partNamingStrategy;
        this.partCleanupStrategy = partCleanupStrategy;
        this.maxElementsPerCompact = maxElementsPerCompact;
        this.finalObject = finalObject;
        this.storage = storage;
        this.ultimateObject = ultimateObject;
        this.opts = opts;
        this.queue = AsyncAppendingQueue.of(exec, maxElementsPerCompact, this::compose);
        this.pendingParts = new ArrayList<ApiFuture<BlobInfo>>();
        this.successfulParts = Collections.synchronizedList(new ArrayList());
        this.open = true;
        this.totalObjectOffset = 0L;
        this.partOpts = ParallelCompositeUploadWritableByteChannel.getPartOpts(opts);
        this.srcOpts = this.partOpts.transformTo(UnifiedOpts.ObjectSourceOpt.class);
        this.cumulativeHasher = Hashing.crc32c().newHasher();
        this.failureForwarder = new FailureForwarder();
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int remaining = src.remaining();
        this.cumulativeHasher.putBytes(src.duplicate());
        while (src.hasRemaining()) {
            if (this.current == null) {
                this.current = this.bufferPool.getBuffer();
            }
            ByteBuffer buf = (ByteBuffer)this.current.getBufferHandle().get();
            Buffers.copy(src, buf);
            if (buf.hasRemaining()) continue;
            this.internalFlush(buf);
        }
        return remaining;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.current != null) {
            ByteBuffer buf = (ByteBuffer)this.current.getBufferHandle().get();
            this.internalFlush(buf);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flush();
        try {
            this.queue.close();
        }
        catch (NoSuchElementException e) {
            try {
                BlobInfo blobInfo = this.storage.internalDirectUpload(this.ultimateObject, this.opts, Buffers.allocate(0));
                this.finalObject.set((Object)blobInfo);
                return;
            }
            catch (StorageException se) {
                this.finalObject.setException((Throwable)((Object)se));
                throw se;
            }
        }
        String expectedCrc32c = (String)Utils.crc32cCodec.encode(this.cumulativeHasher.hash().asInt());
        ApiFuture closingTransform = ApiFutures.transformAsync(this.queue.getResult(), this::cleanupParts, (Executor)this.exec);
        ApiFuture validatingTransform = ApiFutures.transformAsync((ApiFuture)closingTransform, finalInfo -> {
            String crc32c = finalInfo.getCrc32c();
            if (expectedCrc32c.equals(crc32c)) {
                return ApiFutures.immediateFuture((Object)finalInfo);
            }
            return ApiFutures.immediateFailedFuture((Throwable)StorageException.coalesce((Throwable)((Object)ParallelCompositeUploadWritableByteChannel.buildParallelCompositeUploadException(ApiExceptionFactory.createException((String)String.format("CRC32C Checksum mismatch. expected: [%s] but was: [%s]", expectedCrc32c, crc32c), null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DATA_LOSS), (boolean)false), this.exec, this.pendingParts, this.successfulParts))));
        }, (Executor)this.exec);
        if (this.partCleanupStrategy.isDeleteAllOnError()) {
            ApiFuture cleaningFuture = ApiFutures.catchingAsync((ApiFuture)validatingTransform, Throwable.class, this::asyncCleanupAfterFailure, (Executor)this.exec);
            ApiFutures.addCallback((ApiFuture)cleaningFuture, (ApiFutureCallback)this.failureForwarder, (Executor)this.exec);
        } else {
            ApiFutures.addCallback((ApiFuture)validatingTransform, (ApiFutureCallback)this.failureForwarder, (Executor)this.exec);
        }
        try {
            ApiFutureUtils.await(validatingTransform);
        }
        catch (Throwable t) {
            AsynchronousCloseException e = new AsynchronousCloseException();
            e.initCause(t);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush(ByteBuffer buf) {
        block7: {
            Buffers.flip(buf);
            int pendingByteCount = buf.remaining();
            int partIndex = this.pendingParts.size() + 1;
            BlobInfo partInfo = this.definePart(this.ultimateObject, MetadataField.PartRange.of(partIndex), this.totalObjectOffset);
            ApiFuture partFuture = ApiFutures.transform((ApiFuture)ApiFutures.immediateFuture((Object)partInfo), info -> {
                try {
                    return this.storage.internalDirectUpload((BlobInfo)info, this.partOpts, buf);
                }
                catch (StorageException e) {
                    if (e.getCode() == 412) {
                        return this.storage.internalObjectGet(info.getBlobId(), this.srcOpts);
                    }
                    throw e;
                }
            }, (Executor)this.exec);
            ApiFutures.addCallback((ApiFuture)partFuture, new BufferHandleReleaser(this.bufferPool, this.current, result -> this.successfulParts.add(result.getBlobId())), (Executor)this.exec);
            this.pendingParts.add((ApiFuture<BlobInfo>)partFuture);
            try {
                this.queue.append((ApiFuture<BlobInfo>)partFuture);
                this.totalObjectOffset += (long)pendingByteCount;
            }
            catch (AsyncAppendingQueue.ShortCircuitException e) {
                BaseServiceException storageException;
                this.open = false;
                this.bufferPool.returnBuffer(this.current);
                for (ApiFuture<BlobInfo> pendingPart : this.pendingParts) {
                    pendingPart.cancel(false);
                }
                Throwable cause = e.getCause();
                if (this.partCleanupStrategy.isDeleteAllOnError()) {
                    storageException = StorageException.coalesce(cause);
                    ApiFuture cleanupFutures = this.asyncCleanupAfterFailure((Throwable)storageException);
                    final CancellationException cancellationException = new CancellationException(storageException.getMessage());
                    cancellationException.initCause((Throwable)storageException);
                    ApiFutures.addCallback(cleanupFutures, (ApiFutureCallback)new ApiFutureCallback<Object>(){

                        public void onFailure(Throwable throwable) {
                            cancellationException.addSuppressed(throwable);
                            ParallelCompositeUploadWritableByteChannel.this.failureForwarder.onFailure(cancellationException);
                        }

                        public void onSuccess(Object o) {
                            ParallelCompositeUploadWritableByteChannel.this.failureForwarder.onFailure(cancellationException);
                        }
                    }, (Executor)this.exec);
                    ApiFutureUtils.await(cleanupFutures);
                    break block7;
                }
                ParallelCompositeUploadException pcue = ParallelCompositeUploadWritableByteChannel.buildParallelCompositeUploadException(cause, this.exec, this.pendingParts, this.successfulParts);
                storageException = StorageException.coalesce((Throwable)((Object)pcue));
                CancellationException cancellationException = new CancellationException(storageException.getMessage());
                cancellationException.initCause((Throwable)storageException);
                ApiFutures.addCallback((ApiFuture)ApiFutures.immediateFailedFuture((Throwable)cancellationException), this.failureForwarder::onFailure, (Executor)this.exec);
                throw storageException;
            }
            finally {
                this.current = null;
            }
        }
    }

    private BlobInfo compose(ImmutableList<BlobInfo> parts) {
        Storage.ComposeRequest.Builder builder = Storage.ComposeRequest.newBuilder();
        List sorted = parts.stream().sorted(comparator).collect(Collectors.toList());
        sorted.stream().map(BlobInfo::getBlobId).forEach(id -> builder.addSource(id.getName(), id.getGeneration()));
        if (parts.size() == this.maxElementsPerCompact) {
            BlobInfo first = (BlobInfo)sorted.get(0);
            BlobInfo last = (BlobInfo)sorted.get(sorted.size() - 1);
            long firstIdx = PART_INDEX.readFrom(first).getBegin();
            long lastIdx = PART_INDEX.readFrom(last).getEnd();
            long offset = OBJECT_OFFSET.readFrom(first);
            BlobInfo newPart = this.definePart(this.ultimateObject, MetadataField.PartRange.of(firstIdx, lastIdx), offset);
            builder.setTarget(newPart);
            builder.setTargetOpts(this.partOpts);
        } else {
            builder.setTarget(this.ultimateObject);
            builder.setTargetOpts(this.opts);
        }
        Storage.ComposeRequest composeRequest = builder.build();
        BlobInfo compose = this.storage.compose(composeRequest);
        this.successfulParts.add(compose.getBlobId());
        return compose;
    }

    private ApiFuture<BlobInfo> cleanupParts(BlobInfo finalInfo) {
        if (!this.partCleanupStrategy.isDeletePartsOnSuccess()) {
            return ApiFutures.immediateFuture((Object)finalInfo);
        }
        List deletes = this.successfulParts.stream().filter(id -> !id.equals(finalInfo.getBlobId())).map(this::deleteAsync).collect(Collectors.toList());
        ApiFuture deletes2 = ApiFutureUtils.quietAllAsList(deletes);
        return ApiFutures.catchingAsync((ApiFuture)ApiFutures.transform(deletes2, ignore -> finalInfo, (Executor)this.exec), Throwable.class, cause -> ApiFutures.immediateFailedFuture((Throwable)StorageException.coalesce(cause)), (Executor)this.exec);
    }

    private BlobInfo definePart(BlobInfo ultimateObject, MetadataField.PartRange partRange, long offset) {
        BlobId id = ultimateObject.getBlobId();
        BlobInfo.Builder b = ultimateObject.toBuilder();
        String partName = this.partNamingStrategy.fmtName(id.getName(), partRange);
        b.setBlobId(BlobId.of(id.getBucket(), partName));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<@NonNull String, @Nullable String> metadata = ultimateObject.getMetadata();
        if (metadata != null) {
            builder.putAll(metadata);
        }
        FINAL_OBJECT_NAME.appendTo(id.getName(), (ImmutableMap.Builder<String, String>)builder);
        PART_INDEX.appendTo(partRange, (ImmutableMap.Builder<String, String>)builder);
        OBJECT_OFFSET.appendTo(offset, (ImmutableMap.Builder<String, String>)builder);
        b.setMetadata((Map<String, String>)builder.build());
        return b.build();
    }

    private <R> ApiFuture<R> asyncCleanupAfterFailure(Throwable originalFailure) {
        ApiFuture<List<BlobId>> pendingAndSuccessfulBlobIds = ParallelCompositeUploadWritableByteChannel.getPendingAndSuccessfulBlobIds(this.exec, this.pendingParts, this.successfulParts);
        return ApiFutures.transformAsync(pendingAndSuccessfulBlobIds, blobIds -> {
            ImmutableList pendingDeletes = (ImmutableList)blobIds.stream().map(this::deleteAsync).collect(ImmutableList.toImmutableList());
            ApiFuture futureDeleteResults = ApiFutures.successfulAsList((Iterable)pendingDeletes);
            return ApiFutures.transformAsync((ApiFuture)futureDeleteResults, deleteResults -> {
                ArrayList<BlobId> failedDeletes = new ArrayList<BlobId>();
                for (int i = 0; i < blobIds.size(); ++i) {
                    BlobId id = (BlobId)blobIds.get(i);
                    Boolean deleteResult = (Boolean)deleteResults.get(i);
                    if (Boolean.TRUE.equals(deleteResult)) continue;
                    failedDeletes.add(id);
                }
                if (!failedDeletes.isEmpty()) {
                    String failedGsUris = failedDeletes.stream().map(BlobId::toGsUtilUriWithGeneration).collect(Collectors.joining(",\n", "[\n", "\n]"));
                    String message = String.format("Incomplete parallel composite upload cleanup after previous error. Unknown object ids: %s", failedGsUris);
                    StorageException storageException = new StorageException(0, message, null);
                    originalFailure.addSuppressed((Throwable)((Object)storageException));
                }
                return ApiFutures.immediateFailedFuture((Throwable)originalFailure);
            }, (Executor)this.exec);
        }, (Executor)this.exec);
    }

    private @NonNull ApiFuture<Boolean> deleteAsync(BlobId id) {
        return ApiFutures.transform((ApiFuture)ApiFutures.immediateFuture((Object)id), v -> {
            try {
                this.storage.internalObjectDelete((BlobId)v, this.srcOpts);
                return true;
            }
            catch (NotFoundException e) {
                return true;
            }
            catch (StorageException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw e;
            }
        }, (Executor)this.exec);
    }

    @VisibleForTesting
    static @NonNull UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> getPartOpts(UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        return opts.filter(TO_EXCLUDE_FROM_PARTS).prepend(DOES_NOT_EXIST);
    }

    @VisibleForTesting
    static @NonNull ParallelCompositeUploadException buildParallelCompositeUploadException(Throwable cause, Executor exec, List<ApiFuture<BlobInfo>> pendingParts, List<BlobId> successfulParts) {
        ApiFuture<List<BlobId>> fCreatedObjects = ParallelCompositeUploadWritableByteChannel.getPendingAndSuccessfulBlobIds(exec, pendingParts, successfulParts);
        return ParallelCompositeUploadException.of(cause, fCreatedObjects);
    }

    private static @NonNull ApiFuture<List<BlobId>> getPendingAndSuccessfulBlobIds(Executor exec, List<ApiFuture<BlobInfo>> pendingParts, List<BlobId> successfulParts) {
        ApiFuture successfulList = ApiFutures.successfulAsList(pendingParts);
        ApiFuture catching = ApiFutures.catching((ApiFuture)successfulList, Throwable.class, t2 -> ImmutableList.of(), (Executor)exec);
        ApiFuture fCreatedObjects = ApiFutures.transform((ApiFuture)catching, l -> (List)Stream.of(l.stream().filter(Objects::nonNull).map(BlobInfo::getBlobId), successfulParts.stream()).flatMap(Function.identity()).distinct().collect(ImmutableList.toImmutableList()), (Executor)exec);
        return fCreatedObjects;
    }

    static {
        DOES_NOT_EXIST = UnifiedOpts.Opts.from(UnifiedOpts.generationMatch(0L));
        Predicate<UnifiedOpts.ObjectTargetOpt> tmp = o -> o instanceof UnifiedOpts.GenerationMatch || o instanceof UnifiedOpts.GenerationNotMatch || o instanceof UnifiedOpts.MetagenerationMatch || o instanceof UnifiedOpts.MetagenerationNotMatch || o instanceof UnifiedOpts.SourceGenerationMatch || o instanceof UnifiedOpts.SourceGenerationNotMatch || o instanceof UnifiedOpts.SourceMetagenerationMatch || o instanceof UnifiedOpts.SourceMetagenerationNotMatch || o instanceof UnifiedOpts.Crc32cMatch || o instanceof UnifiedOpts.Md5Match;
        TO_EXCLUDE_FROM_PARTS = tmp.negate();
    }

    private class FailureForwarder
    implements ApiFutureCallback<BlobInfo> {
        private FailureForwarder() {
        }

        public void onFailure(Throwable t) {
            ParallelCompositeUploadWritableByteChannel.this.finalObject.setException(t);
        }

        public void onSuccess(BlobInfo result) {
            ParallelCompositeUploadWritableByteChannel.this.finalObject.set((Object)result);
        }
    }

    @VisibleForTesting
    static final class BufferHandleReleaser<T>
    implements ApiFutureCallback<T> {
        private final BufferHandlePool bufferManager;
        private final ApiFutureCallback<T> delegate;
        private final BufferHandlePool.PooledBuffer toRelease;

        @VisibleForTesting
        BufferHandleReleaser(BufferHandlePool bufferPool, BufferHandlePool.PooledBuffer toRelease, ApiFutureCallback<T> delegate) {
            this.bufferManager = bufferPool;
            this.delegate = delegate;
            this.toRelease = toRelease;
        }

        public void onFailure(Throwable t) {
            try {
                this.delegate.onFailure(t);
            }
            finally {
                this.bufferManager.returnBuffer(this.toRelease);
            }
        }

        public void onSuccess(T result) {
            try {
                this.delegate.onSuccess(result);
            }
            finally {
                this.bufferManager.returnBuffer(this.toRelease);
            }
        }
    }
}

