/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FileRequestLogger
implements RequestLogger {
    private static final Logger log = new Logger(FileRequestLogger.class);
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService exec;
    private final File baseDir;
    private final DateTimeFormatter filePattern;
    private final Duration durationToRetain;
    private final Object lock = new Object();
    private DateTime currentDay;
    private OutputStreamWriter fileWriter;

    public FileRequestLogger(ObjectMapper objectMapper, ScheduledExecutorService exec, File baseDir, String filePattern, Duration durationToRetain) {
        this.exec = exec;
        this.objectMapper = objectMapper;
        this.baseDir = baseDir;
        this.filePattern = DateTimeFormat.forPattern((String)filePattern);
        this.durationToRetain = durationToRetain;
        Preconditions.checkArgument((this.durationToRetain == null || this.durationToRetain.compareTo((ReadableDuration)Duration.standardDays((long)1L)) >= 0 ? 1 : 0) != 0, (Object)"request logs retention period must be atleast P1D");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        try {
            org.apache.druid.java.util.common.FileUtils.mkdirp((File)this.baseDir);
            MutableDateTime mutableDateTime = DateTimes.nowUtc().toMutableDateTime((Chronology)ISOChronology.getInstanceUTC());
            mutableDateTime.setMillisOfDay(0);
            Object object = this.lock;
            synchronized (object) {
                this.currentDay = mutableDateTime.toDateTime((Chronology)ISOChronology.getInstanceUTC());
                this.fileWriter = this.getFileWriter();
            }
            long nextDay = this.currentDay.plusDays(1).getMillis();
            Duration initialDelay = new Duration(nextDay - System.currentTimeMillis());
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)initialDelay, (Duration)Duration.standardDays((long)1L), (Callable)new Callable<ScheduledExecutors.Signal>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScheduledExecutors.Signal call() {
                    try {
                        Object object = FileRequestLogger.this.lock;
                        synchronized (object) {
                            FileRequestLogger.this.currentDay = FileRequestLogger.this.currentDay.plusDays(1);
                            CloseableUtils.closeAndSuppressExceptions((Closeable)FileRequestLogger.this.fileWriter, e -> log.warn("Could not close log file for %s. Creating new log file anyway.", new Object[]{FileRequestLogger.this.currentDay}));
                            FileRequestLogger.this.fileWriter = FileRequestLogger.this.getFileWriter();
                        }
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
            if (this.durationToRetain != null) {
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(0L), (Duration)Duration.standardDays((long)1L), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            long timestamp = System.currentTimeMillis() - FileRequestLogger.this.durationToRetain.getMillis();
                            FileRequestLogger.this.removeFilesOlderThan(timestamp);
                        }
                        catch (Exception ex) {
                            log.error((Throwable)ex, "Failed to clean-up the request logs", new Object[0]);
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeFilesOlderThan(long timestamp) throws IOException {
        File[] files = this.baseDir.listFiles(f -> f.lastModified() < timestamp);
        if (files != null) {
            for (File file : files) {
                log.info("Deleting request log [%s].", new Object[]{file.getAbsolutePath()});
                FileUtils.forceDelete((File)file);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new IOException(new InterruptedException("Thread interrupted. Couldn't delete all tasklogs."));
            }
        }
    }

    private OutputStreamWriter getFileWriter() throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.baseDir, this.filePattern.print((ReadableInstant)this.currentDay)), true), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.fileWriter);
        }
    }

    @Override
    public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
        this.logToFile(requestLogLine.getNativeQueryLine(this.objectMapper));
    }

    @Override
    public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
        this.logToFile(requestLogLine.getSqlQueryLine(this.objectMapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String message) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.fileWriter.write(message);
            this.fileWriter.write("\n");
            this.fileWriter.flush();
        }
    }

    public String toString() {
        return "FileRequestLogger{baseDir=" + this.baseDir + '}';
    }
}

