/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.error.NotFound;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionProgressResponse;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/coordinator/v1/compaction")
public class CoordinatorCompactionResource {
    private final DruidCoordinator coordinator;
    private final OverlordClient overlordClient;

    @Inject
    public CoordinatorCompactionResource(DruidCoordinator coordinator, OverlordClient overlordClient) {
        this.coordinator = coordinator;
        this.overlordClient = overlordClient;
    }

    @POST
    @Path(value="/compact")
    @ResourceFilters(value={ConfigResourceFilter.class})
    @VisibleForTesting
    public Response forceTriggerCompaction() {
        this.coordinator.runCompactSegmentsDuty();
        return Response.ok().build();
    }

    @GET
    @Path(value="/progress")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getCompactionProgress(@QueryParam(value="dataSource") String dataSource) {
        if (dataSource == null || dataSource.isEmpty()) {
            return ServletResourceUtils.buildErrorResponseFrom(InvalidInput.exception((String)"No DataSource specified", (Object[])new Object[0]));
        }
        if (this.isCompactionSupervisorEnabled()) {
            return this.buildResponse(this.overlordClient.getBytesAwaitingCompaction(dataSource));
        }
        AutoCompactionSnapshot snapshot = this.coordinator.getAutoCompactionSnapshotForDataSource(dataSource);
        if (snapshot == null) {
            return ServletResourceUtils.buildErrorResponseFrom(NotFound.exception((String)"Unknown DataSource", (Object[])new Object[0]));
        }
        return Response.ok((Object)new CompactionProgressResponse(snapshot.getBytesAwaitingCompaction())).build();
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getCompactionSnapshotForDataSource(@QueryParam(value="dataSource") String dataSource) {
        ImmutableList snapshots;
        if (this.isCompactionSupervisorEnabled()) {
            return this.buildResponse(this.overlordClient.getCompactionSnapshots(dataSource));
        }
        if (dataSource == null || dataSource.isEmpty()) {
            snapshots = this.coordinator.getAutoCompactionSnapshot().values();
        } else {
            AutoCompactionSnapshot autoCompactionSnapshot = this.coordinator.getAutoCompactionSnapshotForDataSource(dataSource);
            if (autoCompactionSnapshot == null) {
                return ServletResourceUtils.buildErrorResponseFrom(NotFound.exception((String)"Unknown DataSource", (Object[])new Object[0]));
            }
            snapshots = ImmutableList.of((Object)autoCompactionSnapshot);
        }
        return Response.ok((Object)new CompactionStatusResponse((Collection<AutoCompactionSnapshot>)snapshots)).build();
    }

    @POST
    @Path(value="/simulate")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response simulateWithClusterConfigUpdate(ClusterCompactionConfig updatePayload) {
        return Response.ok().entity((Object)this.coordinator.simulateRunWithConfigUpdate(updatePayload)).build();
    }

    private <T> Response buildResponse(ListenableFuture<T> future) {
        try {
            return Response.ok((Object)FutureUtils.getUnchecked(future, (boolean)true)).build();
        }
        catch (Exception e) {
            if (e.getCause() instanceof HttpResponseException) {
                HttpResponseException cause = (HttpResponseException)e.getCause();
                return Response.status((int)cause.getResponse().getStatus().getCode()).entity((Object)cause.getResponse().getContent()).build();
            }
            return ServletResourceUtils.buildErrorResponseFrom(InternalServerError.exception((String)e.getMessage(), (Object[])new Object[0]));
        }
    }

    private boolean isCompactionSupervisorEnabled() {
        try {
            return (Boolean)FutureUtils.getUnchecked(this.overlordClient.isCompactionSupervisorEnabled(), (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
    }
}

