/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.common.config.Configs;
import org.apache.druid.server.coordinator.config.KillUnusedSegmentsConfig;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.joda.time.Duration;

public class CoordinatorKillConfigs {
    public static CoordinatorKillConfigs DEFAULT = new CoordinatorKillConfigs(null, null, null, null, null, null, null, null, null, null, null, null, null);
    @JsonProperty(value="supervisor")
    private final MetadataCleanupConfig supervisors;
    @JsonProperty(value="audit")
    private final MetadataCleanupConfig auditLogs;
    @JsonProperty(value="datasource")
    private final MetadataCleanupConfig datasources;
    @JsonProperty(value="rule")
    private final MetadataCleanupConfig rules;
    @JsonProperty(value="compaction")
    private final MetadataCleanupConfig compactionConfigs;
    @JsonProperty(value="pendingSegments")
    private final MetadataCleanupConfig pendingSegments;
    @JsonProperty(value="segmentSchema")
    private final MetadataCleanupConfig segmentSchemas;
    @JsonProperty(value="on")
    private final Boolean killUnusedEnabled;
    @JsonProperty(value="period")
    private final Duration killUnusedPeriod;
    @JsonProperty(value="durationToRetain")
    private final Duration killUnusedDurationToRetain;
    @JsonProperty(value="ignoreDurationToRetain")
    private final Boolean killUnusedIgnoreDurationToRetain;
    @JsonProperty(value="bufferPeriod")
    private final Duration killUnusedBufferPeriod;
    @JsonProperty(value="maxSegments")
    private final Integer killUnusedMaxSegments;

    @JsonCreator
    public CoordinatorKillConfigs(@JsonProperty(value="pendingSegments") MetadataCleanupConfig pendingSegments, @JsonProperty(value="supervisor") MetadataCleanupConfig supervisors, @JsonProperty(value="audit") MetadataCleanupConfig auditLogs, @JsonProperty(value="datasource") MetadataCleanupConfig datasources, @JsonProperty(value="rule") MetadataCleanupConfig rules, @JsonProperty(value="compaction") MetadataCleanupConfig compactionConfigs, @JsonProperty(value="segmentSchema") MetadataCleanupConfig segmentSchemas, @JsonProperty(value="on") Boolean killUnusedEnabled, @JsonProperty(value="period") Duration killUnusedPeriod, @JsonProperty(value="durationToRetain") Duration killUnusedDurationToRetain, @JsonProperty(value="ignoreDurationToRetain") Boolean killUnusedIgnoreDurationToRetain, @JsonProperty(value="bufferPeriod") Duration killUnusedBufferPeriod, @JsonProperty(value="maxSegments") Integer killUnusedMaxSegments) {
        this.pendingSegments = (MetadataCleanupConfig)Configs.valueOrDefault((Object)pendingSegments, (Object)MetadataCleanupConfig.DEFAULT);
        this.supervisors = (MetadataCleanupConfig)Configs.valueOrDefault((Object)supervisors, (Object)MetadataCleanupConfig.DEFAULT);
        this.auditLogs = (MetadataCleanupConfig)Configs.valueOrDefault((Object)auditLogs, (Object)MetadataCleanupConfig.DEFAULT);
        this.datasources = (MetadataCleanupConfig)Configs.valueOrDefault((Object)datasources, (Object)MetadataCleanupConfig.DEFAULT);
        this.rules = (MetadataCleanupConfig)Configs.valueOrDefault((Object)rules, (Object)MetadataCleanupConfig.DEFAULT);
        this.compactionConfigs = (MetadataCleanupConfig)Configs.valueOrDefault((Object)compactionConfigs, (Object)MetadataCleanupConfig.DEFAULT);
        this.segmentSchemas = (MetadataCleanupConfig)Configs.valueOrDefault((Object)segmentSchemas, (Object)MetadataCleanupConfig.DEFAULT);
        this.killUnusedEnabled = killUnusedEnabled;
        this.killUnusedPeriod = killUnusedPeriod;
        this.killUnusedDurationToRetain = killUnusedDurationToRetain;
        this.killUnusedBufferPeriod = killUnusedBufferPeriod;
        this.killUnusedIgnoreDurationToRetain = killUnusedIgnoreDurationToRetain;
        this.killUnusedMaxSegments = killUnusedMaxSegments;
    }

    public MetadataCleanupConfig auditLogs() {
        return this.auditLogs;
    }

    public MetadataCleanupConfig datasources() {
        return this.datasources;
    }

    public MetadataCleanupConfig rules() {
        return this.rules;
    }

    public MetadataCleanupConfig compactionConfigs() {
        return this.compactionConfigs;
    }

    public MetadataCleanupConfig pendingSegments() {
        return this.pendingSegments;
    }

    public MetadataCleanupConfig supervisors() {
        return this.supervisors;
    }

    public MetadataCleanupConfig segmentSchemas() {
        return this.segmentSchemas;
    }

    public KillUnusedSegmentsConfig unusedSegments(Duration indexingPeriod) {
        return new KillUnusedSegmentsConfig(this.killUnusedEnabled, (Duration)Configs.valueOrDefault((Object)this.killUnusedPeriod, (Object)indexingPeriod), this.killUnusedDurationToRetain, this.killUnusedIgnoreDurationToRetain, this.killUnusedBufferPeriod, this.killUnusedMaxSegments);
    }
}

