/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.ResourceIdPopulatingQueryRunner;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final QueryProcessingPool queryProcessingPool;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final JoinableFactoryWrapper joinableFactoryWrapper;
    private final ServerConfig serverConfig;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, JoinableFactoryWrapper joinableFactoryWrapper, ServerConfig serverConfig) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.queryProcessingPool = queryProcessingPool;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.joinableFactoryWrapper = joinableFactoryWrapper;
        this.serverConfig = serverConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        DataSourceAnalysis analysis = query.getDataSource().getAnalysis();
        Optional<VersionedIntervalTimeline<String, ReferenceCountingSegment>> maybeTimeline = this.segmentManager.getTimeline(analysis);
        if (!maybeTimeline.isPresent()) {
            return new NoopQueryRunner();
        }
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = maybeTimeline.get();
        FunctionalIterable segmentDescriptors = FunctionalIterable.create(intervals).transformCat(arg_0 -> timeline.lookup(arg_0)).transformCat(holder -> {
            if (holder == null) {
                return null;
            }
            return FunctionalIterable.create((Iterable)holder.getObject()).transform(partitionChunk -> new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), partitionChunk.getChunkNumber()));
        });
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)segmentDescriptors);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> theQuery, Iterable<SegmentDescriptor> specs) {
        Query newQuery = ResourceIdPopulatingQueryRunner.populateResourceId(theQuery);
        DataSource dataSourceFromQuery = newQuery.getDataSource();
        QueryRunnerFactory factory = this.conglomerate.findFactory(newQuery);
        if (factory == null) {
            QueryUnsupportedException e = new QueryUnsupportedException(StringUtils.format((String)"Unknown query type, [%s]", (Object[])new Object[]{newQuery.getClass()}));
            log.makeAlert((Throwable)e, "Error while executing a query[%s]", new Object[]{newQuery.getId()}).addData("dataSource", (Object)dataSourceFromQuery).emit();
            throw e;
        }
        QueryToolChest toolChest = factory.getToolchest();
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        Optional<VersionedIntervalTimeline<String, ReferenceCountingSegment>> maybeTimeline = this.segmentManager.getTimeline(analysis);
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{dataSourceFromQuery});
        }
        if (!maybeTimeline.isPresent()) {
            return new ReportTimelineMissingSegmentQueryRunner((List)Lists.newArrayList(specs));
        }
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = maybeTimeline.get();
        Function segmentMapFn = dataSourceFromQuery.createSegmentMapFunction(newQuery, cpuTimeAccumulator);
        Optional<byte[]> cacheKeyPrefix = Optional.ofNullable(dataSourceFromQuery.getCacheKey());
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(descriptor -> Collections.singletonList(this.buildQueryRunnerForSegment(newQuery, (SegmentDescriptor)descriptor, (QueryRunnerFactory)factory, (QueryToolChest)toolChest, timeline, segmentMapFn, cpuTimeAccumulator, cacheKeyPrefix)));
        return new ResourceIdPopulatingQueryRunner(CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.queryProcessingPool, (Iterable)queryRunners), true), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true));
    }

    protected <T> QueryRunner<T> buildQueryRunnerForSegment(Query<T> query, SegmentDescriptor descriptor, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline, Function<SegmentReference, SegmentReference> segmentMapFn, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix) {
        PartitionChunk chunk = timeline.findChunk(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getPartitionNumber());
        if (chunk == null) {
            return new ReportTimelineMissingSegmentQueryRunner(descriptor);
        }
        ReferenceCountingSegment segment = (ReferenceCountingSegment)chunk.getObject();
        return this.buildAndDecorateQueryRunner(factory, toolChest, segmentMapFn.apply((SegmentReference)segment), cacheKeyPrefix, descriptor, cpuTimeAccumulator);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, SegmentReference segment, Optional<byte[]> cacheKeyPrefix, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        if (segment.isTombstone()) {
            return new NoopQueryRunner();
        }
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        SegmentId segmentId = segment.getId();
        Interval segmentInterval = segment.getDataInterval();
        if (segmentId == null || segmentInterval == null) {
            return new ReportTimelineMissingSegmentQueryRunner(segmentDescriptor);
        }
        String segmentIdString = segmentId.toString();
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, segment, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        TimeBoundaryInspector timeBoundaryInspector = (TimeBoundaryInspector)segment.as(TimeBoundaryInspector.class);
        Interval cacheKeyInterval = timeBoundaryInspector != null ? timeBoundaryInspector.getMinMaxInterval() : segmentInterval;
        CachingQueryRunner cachingQueryRunner = new CachingQueryRunner(segmentIdString, cacheKeyPrefix, segmentDescriptor, cacheKeyInterval, this.objectMapper, this.cache, (QueryToolChest)toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner bySegmentQueryRunner = new BySegmentQueryRunner(segmentId, segmentInterval.getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner specificSegmentQueryRunner = new SpecificSegmentQueryRunner((QueryRunner)metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner((QueryRunner)specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)perSegmentOptimizingQueryRunner, toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }
}

