/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FluentQueryRunner;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.PostProcessingOperator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.ResultLevelCachingQueryRunner;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.ClientQuerySegmentWalkerUtils;
import org.apache.druid.server.LocalQuerySegmentWalker;
import org.apache.druid.server.QuerySwappingQueryRunner;
import org.apache.druid.server.ResourceIdPopulatingQueryRunner;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private static final Logger log = new Logger(ClientQuerySegmentWalker.class);
    private static final int FRAME_SIZE = 8000000;
    public static final String ROWS_COUNT_METRIC = "subquery/rows";
    public static final String BYTES_COUNT_METRIC = "subquery/bytes";
    private final ServiceEmitter emitter;
    private final QuerySegmentWalker clusterClient;
    private final QuerySegmentWalker localClient;
    private final QueryToolChestWarehouse warehouse;
    private final JoinableFactory joinableFactory;
    private final RetryQueryRunnerConfig retryConfig;
    private final ObjectMapper objectMapper;
    private final ServerConfig serverConfig;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final SubqueryGuardrailHelper subqueryGuardrailHelper;
    private final SubqueryCountStatsProvider subqueryStatsProvider;

    public ClientQuerySegmentWalker(ServiceEmitter emitter, QuerySegmentWalker clusterClient, QuerySegmentWalker localClient, QueryToolChestWarehouse warehouse, JoinableFactory joinableFactory, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig, Cache cache, CacheConfig cacheConfig, SubqueryGuardrailHelper subqueryGuardrailHelper, SubqueryCountStatsProvider subqueryStatsProvider) {
        this.emitter = emitter;
        this.clusterClient = clusterClient;
        this.localClient = localClient;
        this.warehouse = warehouse;
        this.joinableFactory = joinableFactory;
        this.retryConfig = retryConfig;
        this.objectMapper = objectMapper;
        this.serverConfig = serverConfig;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.subqueryGuardrailHelper = subqueryGuardrailHelper;
        this.subqueryStatsProvider = subqueryStatsProvider;
    }

    @Inject
    ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient clusterClient, LocalQuerySegmentWalker localClient, QueryToolChestWarehouse warehouse, JoinableFactory joinableFactory, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig, Cache cache, CacheConfig cacheConfig, SubqueryGuardrailHelper subqueryGuardrailHelper, SubqueryCountStatsProvider subqueryStatsProvider) {
        this(emitter, (QuerySegmentWalker)clusterClient, (QuerySegmentWalker)localClient, warehouse, joinableFactory, retryConfig, objectMapper, serverConfig, cache, cacheConfig, subqueryGuardrailHelper, subqueryStatsProvider);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        boolean useNestedForUnknownTypeInSubquery;
        String maxSubqueryMemoryString;
        long maxSubqueryMemory;
        int maxSubqueryRows;
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        Query newQuery = query.withDataSource(this.generateSubqueryIds(query.getDataSource(), query.getId(), query.getSqlQueryId()));
        DataSource freeTradeDataSource = this.globalizeIfPossible((newQuery = ResourceIdPopulatingQueryRunner.populateResourceId(newQuery)).getDataSource());
        DataSource inlineDryRun = this.inlineIfNecessary(freeTradeDataSource, toolChest, new AtomicInteger(), new AtomicLong(), new AtomicBoolean(false), maxSubqueryRows = query.context().getMaxSubqueryRows(this.serverConfig.getMaxSubqueryRows()), maxSubqueryMemory = this.subqueryGuardrailHelper.convertSubqueryLimitStringToLong(maxSubqueryMemoryString = query.context().getMaxSubqueryMemoryBytes(this.serverConfig.getMaxSubqueryBytes())), useNestedForUnknownTypeInSubquery = query.context().isUseNestedForUnknownTypeInSubquery(this.serverConfig.isuseNestedForUnknownTypeInSubquery()), true);
        if (!this.canRunQueryUsingClusterWalker(query.withDataSource(inlineDryRun)) && !this.canRunQueryUsingLocalWalker(query.withDataSource(inlineDryRun))) {
            throw new ISE("Cannot handle subquery structure for dataSource: %s", new Object[]{query.getDataSource()});
        }
        AtomicLong memoryLimitAcc = new AtomicLong(0L);
        DataSource maybeInlinedDataSource = this.inlineIfNecessary(freeTradeDataSource, toolChest, new AtomicInteger(), memoryLimitAcc, new AtomicBoolean(false), maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, false);
        newQuery = newQuery.withDataSource(maybeInlinedDataSource);
        log.debug("Memory used by subqueries of query [%s] is [%d]", new Object[]{query, memoryLimitAcc.get()});
        if (this.canRunQueryUsingLocalWalker(newQuery)) {
            return new QuerySwappingQueryRunner<T>(this.localClient.getQueryRunnerForIntervals(newQuery, intervals), query, newQuery);
        }
        if (this.canRunQueryUsingClusterWalker(newQuery)) {
            return new QuerySwappingQueryRunner<T>(this.decorateClusterRunner(newQuery, this.clusterClient.getQueryRunnerForIntervals(newQuery, intervals)), query, newQuery);
        }
        throw new ISE("Inlined query could not be run", new Object[0]);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        Query freeTradeQuery = query.withDataSource(this.globalizeIfPossible(query.getDataSource()));
        freeTradeQuery = ResourceIdPopulatingQueryRunner.populateResourceId(freeTradeQuery);
        if (this.canRunQueryUsingClusterWalker(query)) {
            return new QuerySwappingQueryRunner(this.decorateClusterRunner(freeTradeQuery, this.clusterClient.getQueryRunnerForSegments(freeTradeQuery, specs)), query, freeTradeQuery);
        }
        throw new ISE("Cannot run query on specific segments (must be table-based; outer query, if present, must be handleable by the query toolchest natively)", new Object[0]);
    }

    private <T> boolean canRunQueryUsingLocalWalker(Query<T> query) {
        DataSource dataSourceFromQuery = query.getDataSource();
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return analysis.isConcreteBased() && !analysis.isConcreteAndTableBased() && dataSourceFromQuery.isGlobal() && (!(dataSourceFromQuery instanceof QueryDataSource) || toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery()));
    }

    private <T> boolean canRunQueryUsingClusterWalker(Query<T> query) {
        DataSource dataSourceFromQuery = query.getDataSource();
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return analysis.isConcreteAndTableBased() && (!(dataSourceFromQuery instanceof QueryDataSource) || toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery()));
    }

    private DataSource globalizeIfPossible(DataSource dataSource) {
        if (dataSource instanceof TableDataSource) {
            GlobalTableDataSource maybeGlobal = new GlobalTableDataSource(((TableDataSource)dataSource).getName());
            if (this.joinableFactory.isDirectlyJoinable((DataSource)maybeGlobal)) {
                return maybeGlobal;
            }
            return dataSource;
        }
        List currentChildren = dataSource.getChildren();
        ArrayList<DataSource> newChildren = new ArrayList<DataSource>(currentChildren.size());
        for (DataSource child : currentChildren) {
            newChildren.add(this.globalizeIfPossible(child));
        }
        return dataSource.withChildren(newChildren);
    }

    private <T> DataSource inlineIfNecessary(DataSource dataSource, @Nullable QueryToolChest toolChestIfOutermost, AtomicInteger subqueryRowLimitAccumulator, AtomicLong subqueryMemoryLimitAccumulator, AtomicBoolean cannotMaterializeToFrames, int maxSubqueryRows, long maxSubqueryMemory, boolean useNestedForUnknownTypeInSubquery, boolean dryRun) {
        if (dataSource instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)dataSource).getQuery();
            QueryToolChest toolChest = this.warehouse.getToolChest(subQuery);
            if (toolChestIfOutermost != null && toolChestIfOutermost.canPerformSubquery(subQuery)) {
                Stack<DataSource> stack = new Stack<DataSource>();
                DataSource current = dataSource;
                while (current instanceof QueryDataSource) {
                    stack.push(current);
                    current = (DataSource)Iterables.getOnlyElement((Iterable)current.getChildren());
                }
                if (current instanceof QueryDataSource) {
                    throw new ISE("Got a QueryDataSource[%s], should've walked it away in the loop above.", new Object[]{current});
                }
                current = this.inlineIfNecessary(current, null, subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, dryRun);
                while (!stack.isEmpty()) {
                    current = ((DataSource)stack.pop()).withChildren(Collections.singletonList(current));
                }
                if (!(current instanceof QueryDataSource)) {
                    throw new ISE("Should have a QueryDataSource, but got[%s] instead", new Object[]{current});
                }
                if (toolChest.canPerformSubquery(((QueryDataSource)current).getQuery())) {
                    return current;
                }
                return this.inlineIfNecessary(current, toolChestIfOutermost, subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, dryRun);
            }
            if (this.canRunQueryUsingLocalWalker(subQuery) || this.canRunQueryUsingClusterWalker(subQuery)) {
                Sequence queryResults;
                if (dryRun) {
                    queryResults = Sequences.empty();
                } else {
                    Query subQueryWithSerialization = subQuery.withOverriddenContext(Collections.singletonMap("serialization", ClientQuerySegmentWalkerUtils.getLimitType(maxSubqueryMemory, cannotMaterializeToFrames.get()).serializationMode().toString()));
                    queryResults = subQueryWithSerialization.getRunner((QuerySegmentWalker)this).run(QueryPlus.wrap((Query)subQueryWithSerialization), (ResponseContext)DirectDruidClient.makeResponseContextForQuery());
                }
                return ClientQuerySegmentWalker.toInlineDataSource(subQuery, queryResults, this.warehouse.getToolChest(subQuery), subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, this.subqueryStatsProvider, !dryRun, this.emitter);
            }
            return this.inlineIfNecessary(dataSource.withChildren(Collections.singletonList(this.inlineIfNecessary((DataSource)Iterables.getOnlyElement((Iterable)dataSource.getChildren()), null, subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, dryRun))), toolChestIfOutermost, subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, dryRun);
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(child -> this.inlineIfNecessary((DataSource)child, null, subqueryRowLimitAccumulator, subqueryMemoryLimitAccumulator, cannotMaterializeToFrames, maxSubqueryRows, maxSubqueryMemory, useNestedForUnknownTypeInSubquery, dryRun)).collect(Collectors.toList()));
    }

    private <T> QueryRunner<T> decorateClusterRunner(Query<T> query, QueryRunner<T> baseClusterRunner) {
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        SetAndVerifyContextQueryRunner<T> baseRunner = new SetAndVerifyContextQueryRunner<T>(this.serverConfig, new RetryQueryRunner<T>(baseClusterRunner, (arg_0, arg_1) -> ((QuerySegmentWalker)this.clusterClient).getQueryRunnerForSegments(arg_0, arg_1), this.retryConfig, this.objectMapper));
        return FluentQueryRunner.create(baseRunner, (QueryToolChest)toolChest).applyPreMergeDecoration().mergeResults(false).applyPostMergeDecoration().emitCPUTimeMetric(this.emitter).postProcess((PostProcessingOperator)this.objectMapper.convertValue((Object)query.context().getString("postProcessing"), new TypeReference<PostProcessingOperator<T>>(){})).map(runner -> new ResultLevelCachingQueryRunner((QueryRunner)runner, toolChest, query, this.objectMapper, this.cache, this.cacheConfig));
    }

    private DataSource generateSubqueryIds(DataSource rootDataSource, @Nullable String parentQueryId, @Nullable String parentSqlQueryId) {
        ArrayDeque<DataSource> queue = new ArrayDeque<DataSource>();
        queue.add(rootDataSource);
        HashMap<QueryDataSource, Pair<Integer, Integer>> queryDataSourceToSubqueryIds = new HashMap<QueryDataSource, Pair<Integer, Integer>>();
        int level = 1;
        while (!queue.isEmpty()) {
            int size = queue.size();
            int siblingOrder = 1;
            for (int i = 0; i < size; ++i) {
                DataSource currentDataSource = (DataSource)queue.poll();
                if (currentDataSource == null) continue;
                if (currentDataSource instanceof QueryDataSource) {
                    queryDataSourceToSubqueryIds.put((QueryDataSource)currentDataSource, (Pair<Integer, Integer>)new Pair((Object)level, (Object)siblingOrder));
                    ++siblingOrder;
                }
                queue.addAll(currentDataSource.getChildren());
            }
            ++level;
        }
        return this.insertSubqueryIds(rootDataSource, queryDataSourceToSubqueryIds, parentQueryId, parentSqlQueryId);
    }

    private DataSource insertSubqueryIds(DataSource currentDataSource, Map<QueryDataSource, Pair<Integer, Integer>> queryDataSourceToSubqueryIds, @Nullable String parentQueryId, @Nullable String parentSqlQueryId) {
        if (currentDataSource instanceof QueryDataSource && queryDataSourceToSubqueryIds.containsKey((QueryDataSource)currentDataSource)) {
            QueryDataSource queryDataSource = (QueryDataSource)currentDataSource;
            Pair<Integer, Integer> nestingInfo = queryDataSourceToSubqueryIds.get(queryDataSource);
            String subQueryId = nestingInfo.lhs + "." + nestingInfo.rhs;
            Query query = queryDataSource.getQuery();
            if (org.apache.commons.lang.StringUtils.isEmpty((String)query.getSubQueryId())) {
                query = query.withSubQueryId(subQueryId);
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)query.getId()) && org.apache.commons.lang.StringUtils.isNotEmpty((String)parentQueryId)) {
                query = query.withId(parentQueryId);
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)query.getSqlQueryId()) && org.apache.commons.lang.StringUtils.isNotEmpty((String)parentSqlQueryId)) {
                query = query.withSqlQueryId(parentSqlQueryId);
            }
            currentDataSource = new QueryDataSource(query);
        }
        return currentDataSource.withChildren(currentDataSource.getChildren().stream().map(childDataSource -> this.insertSubqueryIds((DataSource)childDataSource, queryDataSourceToSubqueryIds, parentQueryId, parentSqlQueryId)).collect(Collectors.toList()));
    }

    private static <T, QueryType extends Query<T>> DataSource toInlineDataSource(QueryType query, Sequence<T> queryResults, QueryToolChest<T, QueryType> toolChest, AtomicInteger limitAccumulator, AtomicLong memoryLimitAccumulator, AtomicBoolean cannotMaterializeToFrames, int limit, long memoryLimit, boolean useNestedForUnknownTypeInSubquery, SubqueryCountStatsProvider subqueryStatsProvider, boolean emitMetrics, ServiceEmitter emitter) {
        DataSource dataSource;
        int rowLimitToUse = limit < 0 ? Integer.MAX_VALUE : limit;
        switch (ClientQuerySegmentWalkerUtils.getLimitType(memoryLimit, cannotMaterializeToFrames.get())) {
            case ROW_LIMIT: {
                if (limitAccumulator.get() >= rowLimitToUse) {
                    subqueryStatsProvider.incrementQueriesExceedingRowLimit();
                    throw ResourceLimitExceededException.withMessage((String)ClientQuerySegmentWalker.rowLimitExceededMessage(rowLimitToUse), (Object[])new Object[0]);
                }
                subqueryStatsProvider.incrementSubqueriesWithRowLimit();
                dataSource = ClientQuerySegmentWalker.materializeResultsAsArray(query, queryResults, toolChest, limitAccumulator, limit, subqueryStatsProvider, emitMetrics, emitter);
                break;
            }
            case MEMORY_LIMIT: {
                if (memoryLimitAccumulator.get() >= memoryLimit) {
                    subqueryStatsProvider.incrementQueriesExceedingByteLimit();
                    throw ResourceLimitExceededException.withMessage((String)ClientQuerySegmentWalker.byteLimitExceededMessage(memoryLimit), (Object[])new Object[0]);
                }
                Optional<DataSource> maybeDataSource = ClientQuerySegmentWalker.materializeResultsAsFrames(query, queryResults, toolChest, limitAccumulator, memoryLimitAccumulator, memoryLimit, useNestedForUnknownTypeInSubquery, subqueryStatsProvider, emitMetrics, emitter);
                if (!maybeDataSource.isPresent()) {
                    cannotMaterializeToFrames.set(true);
                    if (limitAccumulator.get() >= rowLimitToUse) {
                        subqueryStatsProvider.incrementQueriesExceedingRowLimit();
                        throw ResourceLimitExceededException.withMessage((String)ClientQuerySegmentWalker.rowLimitExceededMessage(rowLimitToUse), (Object[])new Object[0]);
                    }
                    subqueryStatsProvider.incrementSubqueriesWithRowLimit();
                    subqueryStatsProvider.incrementSubqueriesFallingBackToRowLimit();
                    dataSource = ClientQuerySegmentWalker.materializeResultsAsArray(query, queryResults, toolChest, limitAccumulator, limit, subqueryStatsProvider, emitMetrics, emitter);
                    break;
                }
                subqueryStatsProvider.incrementSubqueriesWithByteLimit();
                dataSource = maybeDataSource.get();
                break;
            }
            default: {
                throw DruidException.defensive((String)"Only row based and memory based limiting is supported", (Object[])new Object[0]);
            }
        }
        return dataSource;
    }

    private static <T, QueryType extends Query<T>> Optional<DataSource> materializeResultsAsFrames(QueryType query, Sequence<T> results, QueryToolChest<T, QueryType> toolChest, AtomicInteger limitAccumulator, AtomicLong memoryLimitAccumulator, long memoryLimit, boolean useNestedForUnknownTypeInSubquery, SubqueryCountStatsProvider subqueryStatsProvider, boolean emitMetrics, ServiceEmitter emitter) {
        boolean startedAccumulating = false;
        try {
            Optional framesOptional = toolChest.resultsAsFrames(query, results, (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(8000000), useNestedForUnknownTypeInSubquery);
            if (!framesOptional.isPresent()) {
                throw DruidException.defensive((String)"Unable to materialize the results as frames. Defaulting to materializing the results as rows", (Object[])new Object[0]);
            }
            Sequence frames = (Sequence)framesOptional.get();
            ArrayList frameSignaturePairs = new ArrayList();
            startedAccumulating = true;
            int initialSubqueryRows = limitAccumulator.get();
            long initialSubqueryBytes = memoryLimitAccumulator.get();
            frames.forEach(frame -> {
                limitAccumulator.addAndGet(frame.getFrame().numRows());
                if (memoryLimitAccumulator.addAndGet(frame.getFrame().numBytes()) >= memoryLimit) {
                    subqueryStatsProvider.incrementQueriesExceedingByteLimit();
                    throw ResourceLimitExceededException.withMessage((String)ClientQuerySegmentWalker.byteLimitExceededMessage(memoryLimit), (Object[])new Object[0]);
                }
                frameSignaturePairs.add(frame);
            });
            if (emitMetrics) {
                emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("id", (Object)query.getId()).setDimension("subQueryId", (Object)query.getSubQueryId()).setMetric(ROWS_COUNT_METRIC, (Number)(limitAccumulator.get() - initialSubqueryRows)));
                emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("id", (Object)query.getId()).setDimension("subQueryId", (Object)query.getSubQueryId()).setMetric(BYTES_COUNT_METRIC, (Number)(memoryLimitAccumulator.get() - initialSubqueryBytes)));
            }
            return Optional.of(new FrameBasedInlineDataSource(frameSignaturePairs, toolChest.resultArraySignature(query)));
        }
        catch (UnsupportedColumnTypeException e) {
            subqueryStatsProvider.incrementSubqueriesFallingBackDueToUnsufficientTypeInfo();
            log.debug((Throwable)e, "Type info in signature insufficient to materialize rows as frames.", new Object[0]);
            return Optional.empty();
        }
        catch (ResourceLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            if (startedAccumulating) {
                throw DruidException.defensive().build((Throwable)e, "Unable to materialize the results as frames for estimating the byte footprint. Please disable the 'maxSubqueryBytes' by setting it to 'disabled' in the query context or removing it altogether from the query context and/or the server config.", new Object[0]);
            }
            return Optional.empty();
        }
    }

    private static <T, QueryType extends Query<T>> DataSource materializeResultsAsArray(QueryType query, Sequence<T> results, QueryToolChest<T, QueryType> toolChest, AtomicInteger limitAccumulator, int limit, SubqueryCountStatsProvider subqueryStatsProvider, boolean emitMetrics, ServiceEmitter emitter) {
        int rowLimitToUse = limit < 0 ? Integer.MAX_VALUE : limit;
        RowSignature signature = toolChest.resultArraySignature(query);
        ArrayList resultList = new ArrayList();
        int initialSubqueryRows = limitAccumulator.get();
        toolChest.resultsAsArrays(query, results).accumulate(resultList, (acc, in) -> {
            if (limitAccumulator.getAndIncrement() >= rowLimitToUse) {
                subqueryStatsProvider.incrementQueriesExceedingRowLimit();
                throw ResourceLimitExceededException.withMessage((String)ClientQuerySegmentWalker.rowLimitExceededMessage(rowLimitToUse), (Object[])new Object[0]);
            }
            acc.add(in);
            return acc;
        });
        if (emitMetrics) {
            emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("id", (Object)query.getId()).setDimension("subQueryId", (Object)query.getSubQueryId()).setMetric(ROWS_COUNT_METRIC, (Number)(limitAccumulator.get() - initialSubqueryRows)));
        }
        return InlineDataSource.fromIterable(resultList, (RowSignature)signature);
    }

    private static String byteLimitExceededMessage(long memoryLimit) {
        return StringUtils.format((String)"Cannot issue the query, subqueries generated results beyond maximum[%d] bytes. Increase the JVM's memory or set the '%s' in the query context to increase the space allocated for subqueries to materialize their results. Manually alter the value carefully as it can cause the broker to go out of memory.", (Object[])new Object[]{memoryLimit, "maxSubqueryBytes"});
    }

    private static String rowLimitExceededMessage(int rowLimitUsed) {
        return StringUtils.format((String)"Cannot issue the query, subqueries generated results beyond maximum[%d] rows. Try setting the '%s' in the query context to '%s' for enabling byte based limit, which chooses an optimal limit based on memory size and result's heap usage or manually configure the values of either '%s' or '%s' in the query context. Manually alter the value carefully as it can cause the broker to go out of memory.", (Object[])new Object[]{rowLimitUsed, "maxSubqueryBytes", "auto", "maxSubqueryBytes", "maxSubqueryRows"});
    }
}

