/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.ReadablePeriod;

public abstract class AbstractSegmentMetadataCache<T extends DataSourceInformation> {
    private static final EmittingLogger log = new EmittingLogger(AbstractSegmentMetadataCache.class);
    private static final int MAX_SEGMENTS_PER_QUERY = 15000;
    private static final long DEFAULT_NUM_ROWS = 0L;
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final SegmentMetadataCacheConfig config;
    private final Escalator escalator;
    private final ColumnTypeMergePolicy columnTypeMergePolicy;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final InternalQueryConfig internalQueryConfig;
    @GuardedBy(value="lock")
    private boolean refreshImmediately = false;
    private int totalSegments = 0;
    protected static final Comparator<SegmentId> SEGMENT_ORDER = Comparator.comparing(segmentId -> segmentId.getInterval().getStart()).reversed().thenComparing(Function.identity());
    protected static final Interner<RowSignature> ROW_SIGNATURE_INTERNER = Interners.newWeakInterner();
    protected final ConcurrentHashMap<String, ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata>> segmentMetadataInfo = new ConcurrentHashMap();
    protected final ExecutorService cacheExec;
    protected final ExecutorService callbackExec;
    @GuardedBy(value="lock")
    protected boolean isServerViewInitialized = false;
    protected final ServiceEmitter emitter;
    protected final ConcurrentHashMap<String, T> tables = new ConcurrentHashMap();
    protected final Object lock = new Object();
    @GuardedBy(value="lock")
    protected final TreeSet<SegmentId> mutableSegments = new TreeSet<SegmentId>(SEGMENT_ORDER);
    @GuardedBy(value="lock")
    protected final Set<String> dataSourcesNeedingRebuild = new HashSet<String>();
    @GuardedBy(value="lock")
    protected final TreeSet<SegmentId> segmentsNeedingRefresh = new TreeSet<SegmentId>(SEGMENT_ORDER);

    public AbstractSegmentMetadataCache(QueryLifecycleFactory queryLifecycleFactory, SegmentMetadataCacheConfig config, Escalator escalator, InternalQueryConfig internalQueryConfig, ServiceEmitter emitter) {
        this.queryLifecycleFactory = (QueryLifecycleFactory)Preconditions.checkNotNull((Object)queryLifecycleFactory, (Object)"queryLifecycleFactory");
        this.config = (SegmentMetadataCacheConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.columnTypeMergePolicy = config.getMetadataColumnTypeMergePolicy();
        this.cacheExec = Execs.singleThreaded((String)"DruidSchema-Cache-%d");
        this.callbackExec = Execs.singleThreaded((String)"DruidSchema-Callback-%d");
        this.escalator = escalator;
        this.internalQueryConfig = internalQueryConfig;
        this.emitter = emitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cacheExecLoop() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long lastRefresh = 0L;
        long lastFailure = 0L;
        try {
            this.refreshWaitCondition();
            while (!Thread.currentThread().isInterrupted()) {
                TreeSet<SegmentId> segmentsToRefresh = new TreeSet<SegmentId>();
                TreeSet<String> dataSourcesToRebuild = new TreeSet<String>();
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        long nextRefreshNoFuzz = DateTimes.utc((long)lastRefresh).plus((ReadablePeriod)this.config.getMetadataRefreshPeriod()).getMillis();
                        long nextRefresh = nextRefreshNoFuzz + (long)((double)(nextRefreshNoFuzz - lastRefresh) * 0.1);
                        while (true) {
                            boolean wasRecentFailure = DateTimes.utc((long)lastFailure).plus((ReadablePeriod)this.config.getMetadataRefreshPeriod()).isAfterNow();
                            if (this.isServerViewInitialized && !wasRecentFailure && this.shouldRefresh() && (this.refreshImmediately || nextRefresh < System.currentTimeMillis())) break;
                            if (this.isServerViewInitialized && lastFailure == 0L) {
                                this.setInitializedAndReportInitTime(stopwatch);
                            }
                            this.lock.wait(Math.max(1L, nextRefresh - System.currentTimeMillis()));
                        }
                        segmentsToRefresh.addAll(this.segmentsNeedingRefresh);
                        this.segmentsNeedingRefresh.clear();
                        this.segmentsNeedingRefresh.addAll(this.mutableSegments);
                        lastFailure = 0L;
                        lastRefresh = System.currentTimeMillis();
                        this.refreshImmediately = false;
                    }
                    this.refresh(segmentsToRefresh, dataSourcesToRebuild);
                    this.setInitializedAndReportInitTime(stopwatch);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Metadata refresh failed, trying again soon.", new Object[0]);
                    Object object = this.lock;
                    synchronized (object) {
                        this.segmentsNeedingRefresh.addAll(segmentsToRefresh);
                        this.dataSourcesNeedingRebuild.addAll(dataSourcesToRebuild);
                        lastFailure = System.currentTimeMillis();
                    }
                }
            }
            return;
        }
        catch (InterruptedException segmentsToRefresh) {
            return;
        }
        catch (Throwable e) {
            log.makeAlert(e, "Metadata refresh failed permanently", new Object[0]).emit();
            throw e;
        }
        finally {
            log.info("Metadata refresh stopped.", new Object[0]);
        }
    }

    public abstract void start() throws InterruptedException;

    public abstract void stop();

    private void setInitializedAndReportInitTime(Stopwatch stopwatch) {
        if (this.initialized.getCount() == 1L) {
            long elapsedTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/init/time", (Number)elapsedTime));
            log.info("%s initialized in [%,d] ms.", new Object[]{this.getClass().getSimpleName(), elapsedTime});
            stopwatch.stop();
        }
        this.initialized.countDown();
    }

    public void refreshWaitCondition() throws InterruptedException {
    }

    protected boolean shouldRefresh() {
        return !this.segmentsNeedingRefresh.isEmpty() || !this.dataSourcesNeedingRebuild.isEmpty();
    }

    public void awaitInitialization() throws InterruptedException {
        this.initialized.await();
    }

    @Nullable
    public T getDatasource(String name) {
        return (T)((DataSourceInformation)this.tables.get(name));
    }

    public Map<String, T> getDataSourceInformationMap() {
        return ImmutableMap.copyOf(this.tables);
    }

    public Set<String> getDatasourceNames() {
        return this.tables.keySet();
    }

    public Map<SegmentId, AvailableSegmentMetadata> getSegmentMetadataSnapshot() {
        HashMap segmentMetadata = Maps.newHashMapWithExpectedSize((int)this.getTotalSegments());
        Iterator<AvailableSegmentMetadata> it = this.iterateSegmentMetadata();
        while (it.hasNext()) {
            AvailableSegmentMetadata availableSegmentMetadata = it.next();
            segmentMetadata.put(availableSegmentMetadata.getSegment().getId(), availableSegmentMetadata);
        }
        return segmentMetadata;
    }

    public Iterator<AvailableSegmentMetadata> iterateSegmentMetadata() {
        return FluentIterable.from(this.segmentMetadataInfo.values()).transformAndConcat(Map::values).iterator();
    }

    @Nullable
    public AvailableSegmentMetadata getAvailableSegmentMetadata(String datasource, SegmentId segmentId) {
        ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata> dataSourceMap = this.segmentMetadataInfo.get(datasource);
        if (dataSourceMap == null) {
            return null;
        }
        return dataSourceMap.get(segmentId);
    }

    public int getTotalSegments() {
        return this.totalSegments;
    }

    public abstract void refresh(Set<SegmentId> var1, Set<String> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addSegment(DruidServerMetadata server, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            if (server.getType().equals((Object)ServerType.BROKER)) {
                this.markDataSourceAsNeedRebuild(segment.getDataSource());
            } else {
                this.segmentMetadataInfo.compute(segment.getDataSource(), (datasource, segmentsMap) -> {
                    if (segmentsMap == null) {
                        segmentsMap = new ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata>(SEGMENT_ORDER);
                    }
                    segmentsMap.compute(segment.getId(), (segmentId, segmentMetadata) -> {
                        if (segmentMetadata == null) {
                            ++this.totalSegments;
                            long isRealtime = server.isSegmentReplicationTarget() ? 0L : 1L;
                            segmentMetadata = AvailableSegmentMetadata.builder(segment, isRealtime, (Set<DruidServerMetadata>)ImmutableSet.of((Object)server), null, 0L).build();
                            if (segment.isTombstone()) {
                                log.debug("Skipping refresh for tombstone segment.", new Object[0]);
                            } else {
                                this.markSegmentAsNeedRefresh(segment.getId());
                            }
                            if (!server.isSegmentReplicationTarget()) {
                                log.debug("Added new mutable segment [%s].", new Object[]{segment.getId()});
                                this.markSegmentAsMutable(segment.getId());
                            } else {
                                log.debug("Added new immutable segment [%s].", new Object[]{segment.getId()});
                            }
                        } else {
                            Set<DruidServerMetadata> segmentServers = segmentMetadata.getReplicas();
                            ImmutableSet servers = new ImmutableSet.Builder().addAll(segmentServers).add((Object)server).build();
                            segmentMetadata = AvailableSegmentMetadata.from(segmentMetadata).withReplicas((Set<DruidServerMetadata>)servers).withRealtime(this.recomputeIsRealtime((ImmutableSet<DruidServerMetadata>)servers)).build();
                            if (server.isSegmentReplicationTarget()) {
                                this.unmarkSegmentAsMutable(segment.getId());
                                log.debug("Segment[%s] has become immutable.", new Object[]{segment.getId()});
                            }
                        }
                        assert (segmentMetadata != null);
                        return segmentMetadata;
                    });
                    return segmentsMap;
                });
            }
            if (!this.tables.containsKey(segment.getDataSource())) {
                this.refreshImmediately = true;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void removeSegment(DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Segment [%s] is gone.", new Object[]{segment.getId()});
            this.segmentsNeedingRefresh.remove(segment.getId());
            this.unmarkSegmentAsMutable(segment.getId());
            this.segmentMetadataInfo.compute(segment.getDataSource(), (dataSource, segmentsMap) -> {
                if (segmentsMap == null) {
                    log.warn("Unknown segment [%s] was removed from the cluster. Ignoring this event.", new Object[]{segment.getId()});
                    return null;
                }
                if (segmentsMap.remove(segment.getId()) == null) {
                    log.warn("Unknown segment [%s] was removed from the cluster. Ignoring this event.", new Object[]{segment.getId()});
                } else {
                    --this.totalSegments;
                }
                this.removeSegmentAction(segment.getId());
                if (segmentsMap.isEmpty()) {
                    this.tables.remove(segment.getDataSource());
                    log.info("dataSource [%s] no longer exists, all metadata removed.", new Object[]{segment.getDataSource()});
                    return null;
                }
                this.markDataSourceAsNeedRebuild(segment.getDataSource());
                return segmentsMap;
            });
            this.lock.notifyAll();
        }
    }

    protected abstract void removeSegmentAction(SegmentId var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Segment [%s] is gone from server [%s]", new Object[]{segment.getId(), server.getName()});
            this.segmentMetadataInfo.compute(segment.getDataSource(), (datasource, knownSegments) -> {
                if (knownSegments == null) {
                    log.warn("Unknown segment [%s] is removed from server [%s]. Ignoring this event", new Object[]{segment.getId(), server.getHost()});
                    return null;
                }
                if (server.getType().equals((Object)ServerType.BROKER)) {
                    if (!knownSegments.isEmpty()) {
                        this.markDataSourceAsNeedRebuild(segment.getDataSource());
                    }
                } else {
                    knownSegments.compute(segment.getId(), (segmentId, segmentMetadata) -> {
                        if (segmentMetadata == null) {
                            log.warn("Unknown segment [%s] is removed from server [%s]. Ignoring this event", new Object[]{segment.getId(), server.getHost()});
                            return null;
                        }
                        Set<DruidServerMetadata> segmentServers = segmentMetadata.getReplicas();
                        ImmutableSet servers = FluentIterable.from(segmentServers).filter(Predicates.not((Predicate)Predicates.equalTo((Object)server))).toSet();
                        return AvailableSegmentMetadata.from(segmentMetadata).withReplicas((Set<DruidServerMetadata>)servers).withRealtime(this.recomputeIsRealtime((ImmutableSet<DruidServerMetadata>)servers)).build();
                    });
                }
                if (knownSegments.isEmpty()) {
                    return null;
                }
                return knownSegments;
            });
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markSegmentAsNeedRefresh(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.segmentsNeedingRefresh.add(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSegmentAsMutable(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.mutableSegments.add(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmarkSegmentAsMutable(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.mutableSegments.remove(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void markDataSourceAsNeedRebuild(String datasource) {
        Object object = this.lock;
        synchronized (object) {
            this.dataSourcesNeedingRebuild.add(datasource);
        }
    }

    @VisibleForTesting
    public Set<SegmentId> refreshSegments(Set<SegmentId> segments) throws IOException {
        HashSet<SegmentId> retVal = new HashSet<SegmentId>();
        TreeMap<String, TreeSet> segmentMap = new TreeMap<String, TreeSet>();
        for (SegmentId segmentId : segments) {
            segmentMap.computeIfAbsent(segmentId.getDataSource(), x -> new TreeSet<SegmentId>(SEGMENT_ORDER)).add(segmentId);
        }
        for (Map.Entry entry : segmentMap.entrySet()) {
            String dataSource = (String)entry.getKey();
            retVal.addAll(this.refreshSegmentsForDataSource(dataSource, (Set)entry.getValue()));
        }
        return retVal;
    }

    private long recomputeIsRealtime(ImmutableSet<DruidServerMetadata> servers) {
        if (servers.isEmpty()) {
            return 0L;
        }
        Optional<DruidServerMetadata> historicalServer = servers.stream().filter(metadata -> metadata.getType().equals((Object)ServerType.HISTORICAL)).findAny();
        return historicalServer.isPresent() ? 0L : 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SegmentId> refreshSegmentsForDataSource(String dataSource, Set<SegmentId> segments) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (!segments.stream().allMatch(segmentId -> segmentId.getDataSource().equals(dataSource))) {
            throw new ISE("'segments' must all match 'dataSource'!", new Object[0]);
        }
        log.debug("Refreshing metadata for datasource[%s].", new Object[]{dataSource});
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource);
        this.emitter.emit((ServiceEventBuilder)builder.setMetric("metadatacache/refresh/count", (Number)segments.size()));
        ImmutableMap segmentIdMap = Maps.uniqueIndex(segments, SegmentId::toString);
        HashSet<SegmentId> retVal = new HashSet<SegmentId>();
        this.logSegmentsToRefresh(dataSource, segments);
        Sequence<SegmentAnalysis> sequence = this.runSegmentMetadataQuery(Iterables.limit(segments, (int)15000));
        try (Yielder yielder = Yielders.each(sequence);){
            while (!yielder.isDone()) {
                SegmentAnalysis analysis = (SegmentAnalysis)yielder.get();
                SegmentId segmentId2 = (SegmentId)segmentIdMap.get(analysis.getId());
                if (segmentId2 == null) {
                    log.warn("Got analysis for segment [%s] we didn't ask for, ignoring.", new Object[]{analysis.getId()});
                } else {
                    RowSignature rowSignature = AbstractSegmentMetadataCache.analysisToRowSignature(analysis);
                    log.debug("Segment[%s] has signature[%s].", new Object[]{segmentId2, rowSignature});
                    if (this.segmentMetadataQueryResultHandler(dataSource, segmentId2, rowSignature, analysis)) {
                        retVal.add(segmentId2);
                    }
                }
                yielder = yielder.next(null);
            }
        }
        long refreshDurationMillis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.emitter.emit((ServiceEventBuilder)builder.setMetric("metadatacache/refresh/time", (Number)refreshDurationMillis));
        log.debug("Refreshed metadata for datasource [%s] in %,d ms (%d segments queried, %d segments left).", new Object[]{dataSource, refreshDurationMillis, retVal.size(), segments.size() - retVal.size()});
        return retVal;
    }

    void logSegmentsToRefresh(String dataSource, Set<SegmentId> ids) {
    }

    protected boolean segmentMetadataQueryResultHandler(String dataSource, SegmentId segmentId, RowSignature rowSignature, SegmentAnalysis analysis) {
        AtomicBoolean added = new AtomicBoolean(false);
        this.segmentMetadataInfo.compute(dataSource, (datasourceKey, dataSourceSegments) -> {
            if (dataSourceSegments == null) {
                log.warn("No segment map found with datasource [%s], skipping refresh of segment [%s]", new Object[]{datasourceKey, segmentId});
                return null;
            }
            dataSourceSegments.compute(segmentId, (segmentIdKey, segmentMetadata) -> {
                if (segmentMetadata == null) {
                    log.warn("No segment [%s] found, skipping refresh", new Object[]{segmentId});
                    return null;
                }
                AvailableSegmentMetadata updatedSegmentMetadata = AvailableSegmentMetadata.from(segmentMetadata).withRowSignature(rowSignature).withNumRows(analysis.getNumRows()).build();
                added.set(true);
                return updatedSegmentMetadata;
            });
            if (dataSourceSegments.isEmpty()) {
                return null;
            }
            return dataSourceSegments;
        });
        return added.get();
    }

    @Nullable
    @VisibleForTesting
    public RowSignature buildDataSourceRowSignature(String dataSource) {
        ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata> segmentsMap = this.segmentMetadataInfo.get(dataSource);
        LinkedHashMap<String, ColumnType> columnTypes = new LinkedHashMap<String, ColumnType>();
        if (segmentsMap != null && !segmentsMap.isEmpty()) {
            for (AvailableSegmentMetadata availableSegmentMetadata : segmentsMap.values()) {
                RowSignature rowSignature = availableSegmentMetadata.getRowSignature();
                if (rowSignature == null) continue;
                for (String column : rowSignature.getColumnNames()) {
                    ColumnType columnType = (ColumnType)rowSignature.getColumnType(column).orElseThrow(() -> new ISE("Encountered null type for column [%s]", new Object[]{column}));
                    columnTypes.compute(column, (c, existingType) -> this.columnTypeMergePolicy.merge((ColumnType)existingType, columnType));
                }
            }
        } else {
            return null;
        }
        RowSignature.Builder builder = RowSignature.builder();
        columnTypes.forEach((arg_0, arg_1) -> ((RowSignature.Builder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TreeSet<SegmentId> getSegmentsNeedingRefresh() {
        Object object = this.lock;
        synchronized (object) {
            return this.segmentsNeedingRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TreeSet<SegmentId> getMutableSegments() {
        Object object = this.lock;
        synchronized (object) {
            return this.mutableSegments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Set<String> getDataSourcesNeedingRebuild() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataSourcesNeedingRebuild;
        }
    }

    protected boolean fetchAggregatorsInSegmentMetadataQuery() {
        return false;
    }

    @VisibleForTesting
    public Sequence<SegmentAnalysis> runSegmentMetadataQuery(Iterable<SegmentId> segments) {
        String dataSource = (String)Iterables.getOnlyElement((Iterable)StreamSupport.stream(segments.spliterator(), false).map(SegmentId::getDataSource).collect(Collectors.toSet()));
        MultipleSpecificSegmentSpec querySegmentSpec = new MultipleSpecificSegmentSpec(StreamSupport.stream(segments.spliterator(), false).map(SegmentId::toDescriptor).collect(Collectors.toList()));
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(dataSource), (QuerySegmentSpec)querySegmentSpec, (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), QueryContexts.override(this.internalQueryConfig.getContext(), (String)"enableParallelMerge", (Object)false), this.fetchAggregatorsInSegmentMetadataQuery() ? EnumSet.of(SegmentMetadataQuery.AnalysisType.AGGREGATORS) : EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        return this.queryLifecycleFactory.factorize().runSimple(segmentMetadataQuery, this.escalator.createEscalatedAuthenticationResult(), Access.OK).getResults();
    }

    @VisibleForTesting
    static RowSignature analysisToRowSignature(SegmentAnalysis analysis) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (Map.Entry entry : analysis.getColumns().entrySet()) {
            if (((ColumnAnalysis)entry.getValue()).isError()) continue;
            ColumnType valueType = ((ColumnAnalysis)entry.getValue()).getTypeSignature();
            if (valueType == null) {
                try {
                    valueType = ColumnType.fromString((String)((ColumnAnalysis)entry.getValue()).getType());
                    if (valueType == null) {
                        valueType = ColumnType.ofComplex((String)((ColumnAnalysis)entry.getValue()).getType());
                    }
                }
                catch (IllegalArgumentException ignored) {
                    valueType = ColumnType.UNKNOWN_COMPLEX;
                }
            }
            rowSignatureBuilder.add((String)entry.getKey(), valueType);
        }
        return (RowSignature)ROW_SIGNATURE_INTERNER.intern((Object)rowSignatureBuilder.build());
    }

    @VisibleForTesting
    public void setAvailableSegmentMetadata(SegmentId segmentId, AvailableSegmentMetadata availableSegmentMetadata) {
        ConcurrentSkipListMap dataSourceSegments = this.segmentMetadataInfo.computeIfAbsent(segmentId.getDataSource(), k -> new ConcurrentSkipListMap(SEGMENT_ORDER));
        if (dataSourceSegments.put(segmentId, availableSegmentMetadata) == null) {
            ++this.totalSegments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void doInLock(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            runnable.run();
        }
    }

    public static class LeastRestrictiveTypeMergePolicy
    implements ColumnTypeMergePolicy {
        public static final String NAME = "leastRestrictive";
        private static final LeastRestrictiveTypeMergePolicy INSTANCE = new LeastRestrictiveTypeMergePolicy();

        @Override
        public ColumnType merge(ColumnType existingType, ColumnType newType) {
            try {
                return ColumnType.leastRestrictiveType((ColumnType)existingType, (ColumnType)newType);
            }
            catch (Types.IncompatibleTypeException incompatibleTypeException) {
                return FirstTypeMergePolicy.INSTANCE.merge(existingType, newType);
            }
        }

        public int hashCode() {
            return Objects.hash(NAME);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return NAME;
        }
    }

    public static class FirstTypeMergePolicy
    implements ColumnTypeMergePolicy {
        public static final String NAME = "latestInterval";
        private static final FirstTypeMergePolicy INSTANCE = new FirstTypeMergePolicy();

        @Override
        public ColumnType merge(ColumnType existingType, ColumnType newType) {
            if (existingType == null) {
                return newType;
            }
            if (newType == null) {
                return existingType;
            }
            if (ColumnType.NESTED_DATA.equals((Object)newType) || ColumnType.NESTED_DATA.equals((Object)existingType)) {
                return ColumnType.NESTED_DATA;
            }
            return existingType;
        }

        public int hashCode() {
            return Objects.hash(NAME);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return NAME;
        }
    }

    @FunctionalInterface
    public static interface ColumnTypeMergePolicy {
        public ColumnType merge(ColumnType var1, ColumnType var2);

        @JsonCreator
        public static ColumnTypeMergePolicy fromString(String type) {
            if ("leastRestrictive".equalsIgnoreCase(type)) {
                return LeastRestrictiveTypeMergePolicy.INSTANCE;
            }
            if ("latestInterval".equalsIgnoreCase(type)) {
                return FirstTypeMergePolicy.INSTANCE;
            }
            throw new IAE("Unknown type [%s]", new Object[]{type});
        }
    }
}

