/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public interface IndexerMetadataStorageCoordinator {
    default public Set<DataSegment> retrieveUsedSegmentsForInterval(String dataSource, Interval interval, Segments visibility) {
        return this.retrieveUsedSegmentsForIntervals(dataSource, Collections.singletonList(interval), visibility);
    }

    public Set<DataSegment> retrieveAllUsedSegments(String var1, Segments var2);

    public Collection<Pair<DataSegment, String>> retrieveUsedSegmentsAndCreatedDates(String var1, List<Interval> var2);

    public Set<DataSegment> retrieveUsedSegmentsForIntervals(String var1, List<Interval> var2, Segments var3);

    default public List<DataSegment> retrieveUnusedSegmentsForInterval(String dataSource, Interval interval, @Nullable Integer limit, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        return this.retrieveUnusedSegmentsForInterval(dataSource, interval, null, limit, maxUsedStatusLastUpdatedTime);
    }

    public List<DataSegment> retrieveUnusedSegmentsForInterval(String var1, Interval var2, @Nullable List<String> var3, @Nullable Integer var4, @Nullable DateTime var5);

    public Set<DataSegment> retrieveSegmentsById(String var1, Set<String> var2);

    public int markSegmentsAsUnusedWithinInterval(String var1, Interval var2);

    public Set<DataSegment> commitSegments(Set<DataSegment> var1, @Nullable SegmentSchemaMapping var2);

    public Map<SegmentCreateRequest, SegmentIdWithShardSpec> allocatePendingSegments(String var1, Interval var2, boolean var3, List<SegmentCreateRequest> var4);

    public SegmentIdWithShardSpec allocatePendingSegment(String var1, String var2, @Nullable String var3, Interval var4, PartialShardSpec var5, String var6, boolean var7, String var8);

    public int deletePendingSegmentsCreatedInInterval(String var1, Interval var2);

    public int deletePendingSegments(String var1);

    public SegmentPublishResult commitSegmentsAndMetadata(Set<DataSegment> var1, @Nullable DataSourceMetadata var2, @Nullable DataSourceMetadata var3, @Nullable SegmentSchemaMapping var4);

    public SegmentPublishResult commitAppendSegments(Set<DataSegment> var1, Map<DataSegment, ReplaceTaskLock> var2, String var3, @Nullable SegmentSchemaMapping var4);

    public SegmentPublishResult commitAppendSegmentsAndMetadata(Set<DataSegment> var1, Map<DataSegment, ReplaceTaskLock> var2, DataSourceMetadata var3, DataSourceMetadata var4, String var5, @Nullable SegmentSchemaMapping var6);

    public SegmentPublishResult commitReplaceSegments(Set<DataSegment> var1, Set<ReplaceTaskLock> var2, @Nullable SegmentSchemaMapping var3);

    public List<PendingSegmentRecord> upgradePendingSegmentsOverlappingWith(Set<DataSegment> var1);

    @Nullable
    public DataSourceMetadata retrieveDataSourceMetadata(String var1);

    public boolean deleteDataSourceMetadata(String var1);

    public boolean resetDataSourceMetadata(String var1, DataSourceMetadata var2) throws IOException;

    public boolean insertDataSourceMetadata(String var1, DataSourceMetadata var2);

    public int removeDataSourceMetadataOlderThan(long var1, @NotNull Set<String> var3);

    public SegmentPublishResult commitMetadataOnly(String var1, DataSourceMetadata var2, DataSourceMetadata var3);

    public void updateSegmentMetadata(Set<DataSegment> var1);

    public void deleteSegments(Set<DataSegment> var1);

    public DataSegment retrieveSegmentForId(String var1, boolean var2);

    public int deleteUpgradeSegmentsForTask(String var1);

    public int deletePendingSegmentsForTaskAllocatorId(String var1, String var2);

    public List<PendingSegmentRecord> getPendingSegments(String var1, Interval var2);

    public Map<String, String> retrieveUpgradedFromSegmentIds(String var1, Set<String> var2);

    public Map<String, Set<String>> retrieveUpgradedToSegmentIds(String var1, Set<String> var2);
}

