/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.druid.indexer.MetadataStorageUpdaterJobHandler;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataStorageUpdaterJobHandler
implements MetadataStorageUpdaterJobHandler {
    private static final Logger log = new Logger(SQLMetadataStorageUpdaterJobHandler.class);
    private final SQLMetadataConnector connector;
    private final IDBI dbi;

    @Inject
    public SQLMetadataStorageUpdaterJobHandler(SQLMetadataConnector connector) {
        this.connector = connector;
        this.dbi = connector.getDBI();
    }

    public void publishSegments(final String tableName, final List<DataSegment> segments, final ObjectMapper mapper) {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                PreparedBatch batch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{tableName, SQLMetadataStorageUpdaterJobHandler.this.connector.getQuoteString()}));
                for (DataSegment segment : segments) {
                    String now = DateTimes.nowUtc().toString();
                    batch.add((Map)new ImmutableMap.Builder().put((Object)"id", (Object)segment.getId().toString()).put((Object)"dataSource", (Object)segment.getDataSource()).put((Object)"created_date", (Object)now).put((Object)"start", (Object)segment.getInterval().getStart().toString()).put((Object)"end", (Object)segment.getInterval().getEnd().toString()).put((Object)"partitioned", (Object)(!(segment.getShardSpec() instanceof NoneShardSpec) ? 1 : 0)).put((Object)"version", (Object)segment.getVersion()).put((Object)"used", (Object)true).put((Object)"payload", (Object)mapper.writeValueAsBytes((Object)segment)).put((Object)"used_status_last_updated", (Object)now).build());
                    log.info("Published %s", new Object[]{segment.getId()});
                }
                batch.execute();
                return null;
            }
        });
    }
}

