/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.timeline.DataSegment;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=RandomServerSelectorStrategy.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="random", value=RandomServerSelectorStrategy.class), @JsonSubTypes.Type(name="connectionCount", value=ConnectionCountServerSelectorStrategy.class)})
public interface ServerSelectorStrategy {
    @Nullable
    default public <T> QueryableDruidServer pick(@Nullable Query<T> query, Set<QueryableDruidServer> servers, DataSegment segment) {
        return (QueryableDruidServer)Iterables.getOnlyElement(this.pick(query, servers, segment, 1), null);
    }

    default public <T> List<QueryableDruidServer> pick(@Nullable Query<T> query, Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
        return this.pick(servers, segment, numServersToPick);
    }

    @Deprecated
    @Nullable
    default public QueryableDruidServer pick(Set<QueryableDruidServer> servers, DataSegment segment) {
        return this.pick(null, servers, segment);
    }

    @Deprecated
    default public List<QueryableDruidServer> pick(Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
        return this.pick(null, servers, segment, numServersToPick);
    }
}

