/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.client.InputStreamHolder;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.utils.CloseableUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.joda.time.Duration;

public class DirectDruidClient<T>
implements QueryRunner<T> {
    public static final String QUERY_FAIL_TIME = "queryFailTime";
    private static final Logger log = new Logger(DirectDruidClient.class);
    private static final int VAL_TO_REDUCE_REMAINING_RESPONSES = -1;
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final String scheme;
    private final String host;
    private final ServiceEmitter emitter;
    private final AtomicInteger openConnections;
    private final boolean isSmile;
    private final ScheduledExecutorService queryCancellationExecutor;

    public static void removeMagicResponseContextFields(ResponseContext responseContext) {
        responseContext.remove(ResponseContext.Keys.QUERY_TOTAL_BYTES_GATHERED);
        responseContext.remove(ResponseContext.Keys.REMAINING_RESPONSES_FROM_QUERY_SERVERS);
    }

    public static ConcurrentResponseContext makeResponseContextForQuery() {
        ConcurrentResponseContext responseContext = ConcurrentResponseContext.createEmpty();
        responseContext.initialize();
        return responseContext;
    }

    public DirectDruidClient(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, ObjectMapper objectMapper, HttpClient httpClient, String scheme, String host, ServiceEmitter emitter, ScheduledExecutorService queryCancellationExecutor) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.scheme = scheme;
        this.host = host;
        this.emitter = emitter;
        this.isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        this.openConnections = new AtomicInteger();
        this.queryCancellationExecutor = queryCancellationExecutor;
    }

    public int getNumOpenConnections() {
        return this.openConnections.get();
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext context) {
        ListenableFuture future;
        final Query query = queryPlus.getQuery();
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        boolean isBySegment = query.context().isBySegment();
        final JavaType queryResultType = isBySegment ? toolChest.getBySegmentResultType() : toolChest.getBaseResultType();
        final String url = this.scheme + "://" + this.host + "/druid/v2/";
        final String cancelUrl = url + query.getId();
        try {
            log.debug("Querying queryId [%s] url [%s]", new Object[]{query.getId(), url});
            final long requestStartTimeNs = System.nanoTime();
            QueryContext queryContext = query.context();
            final long timeoutAt = queryContext.getLong(QUERY_FAIL_TIME);
            final long maxScatterGatherBytes = queryContext.getMaxScatterGatherBytes();
            final AtomicLong totalBytesGathered = context.getTotalBytes();
            final long maxQueuedBytes = queryContext.getMaxQueuedBytes(0L);
            final boolean usingBackpressure = maxQueuedBytes > 0L;
            HttpResponseHandler<InputStream, InputStream> responseHandler = new HttpResponseHandler<InputStream, InputStream>(){
                private final AtomicLong totalByteCount = new AtomicLong(0L);
                private final AtomicLong queuedByteCount = new AtomicLong(0L);
                private final AtomicLong channelSuspendedTime = new AtomicLong(0L);
                private final BlockingQueue<InputStreamHolder> queue = new LinkedBlockingQueue<InputStreamHolder>();
                private final AtomicBoolean done = new AtomicBoolean(false);
                private final AtomicReference<String> fail = new AtomicReference();
                private final AtomicReference<HttpResponseHandler.TrafficCop> trafficCopRef = new AtomicReference();
                private QueryMetrics<? super Query<T>> queryMetrics;
                private long responseStartTimeNs;

                private QueryMetrics<? super Query<T>> acquireResponseMetrics() {
                    if (this.queryMetrics == null) {
                        this.queryMetrics = toolChest.makeMetrics(query);
                        this.queryMetrics.server(DirectDruidClient.this.host);
                    }
                    return this.queryMetrics;
                }

                private boolean enqueue(ChannelBuffer buffer, long chunkNum) throws InterruptedException {
                    InputStreamHolder holder = InputStreamHolder.fromChannelBuffer(buffer, chunkNum);
                    long currentQueuedByteCount = this.queuedByteCount.addAndGet(holder.getLength());
                    this.queue.put(holder);
                    return !usingBackpressure || currentQueuedByteCount < maxQueuedBytes;
                }

                private InputStream dequeue() throws InterruptedException {
                    InputStreamHolder holder = this.queue.poll(this.checkQueryTimeout(), TimeUnit.MILLISECONDS);
                    if (holder == null) {
                        throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query[%s] url[%s] timed out.", (Object[])new Object[]{query.getId(), url}));
                    }
                    long currentQueuedByteCount = this.queuedByteCount.addAndGet(-holder.getLength());
                    if (usingBackpressure && currentQueuedByteCount < maxQueuedBytes) {
                        long backPressureTime = ((HttpResponseHandler.TrafficCop)Preconditions.checkNotNull((Object)this.trafficCopRef.get(), (Object)"No TrafficCop, how can this be?")).resume(holder.getChunkNum());
                        this.channelSuspendedTime.addAndGet(backPressureTime);
                    }
                    return holder.getStream();
                }

                public ClientResponse<InputStream> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
                    boolean continueReading;
                    this.trafficCopRef.set(trafficCop);
                    this.checkQueryTimeout();
                    this.checkTotalBytesLimit(response.getContent().readableBytes());
                    log.debug("Initial response from url[%s] for queryId[%s]", new Object[]{url, query.getId()});
                    this.responseStartTimeNs = System.nanoTime();
                    this.acquireResponseMetrics().reportNodeTimeToFirstByte(this.responseStartTimeNs - requestStartTimeNs).emit(DirectDruidClient.this.emitter);
                    try {
                        log.trace("Got a response from [%s] for query ID[%s], subquery ID[%s]", new Object[]{url, query.getId(), query.getSubQueryId()});
                        String responseContext = response.headers().get("X-Druid-Response-Context");
                        context.addRemainingResponse(query.getMostSpecificId(), -1);
                        if (responseContext != null) {
                            context.merge(ResponseContext.deserialize((String)responseContext, (ObjectMapper)DirectDruidClient.this.objectMapper));
                        }
                        continueReading = this.enqueue(response.getContent(), 0L);
                    }
                    catch (IOException e) {
                        log.error((Throwable)e, "Error parsing response context from url [%s]", new Object[]{url});
                        return ClientResponse.finished((Object)new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw e;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e, "Queue appending interrupted", new Object[0]);
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    this.totalByteCount.addAndGet(response.getContent().readableBytes());
                    return ClientResponse.finished((Object)new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean hasMoreElements() {
                            if (fail.get() != null) {
                                throw new RE((String)fail.get(), new Object[0]);
                            }
                            this.checkQueryTimeout();
                            AtomicBoolean atomicBoolean = done;
                            synchronized (atomicBoolean) {
                                return !done.get() || !queue.isEmpty();
                            }
                        }

                        @Override
                        public InputStream nextElement() {
                            if (fail.get() != null) {
                                throw new RE((String)fail.get(), new Object[0]);
                            }
                            try {
                                return this.dequeue();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new RuntimeException(e);
                            }
                        }
                    }), (boolean)continueReading);
                }

                public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk, long chunkNum) {
                    this.checkQueryTimeout();
                    ChannelBuffer channelBuffer = chunk.getContent();
                    int bytes = channelBuffer.readableBytes();
                    this.checkTotalBytesLimit(bytes);
                    boolean continueReading = true;
                    if (bytes > 0) {
                        try {
                            continueReading = this.enqueue(channelBuffer, chunkNum);
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e, "Unable to put finalizing input stream into Sequence queue for url [%s]", new Object[]{url});
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                        }
                        this.totalByteCount.addAndGet(bytes);
                    }
                    return ClientResponse.finished((Object)((InputStream)clientResponse.getObj()), (boolean)continueReading);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
                    long stopTimeNs = System.nanoTime();
                    long nodeTimeNs = stopTimeNs - requestStartTimeNs;
                    long nodeTimeMs = TimeUnit.NANOSECONDS.toMillis(nodeTimeNs);
                    log.debug("Completed queryId[%s] request to url[%s] with %,d bytes returned in %,d millis [%,f b/s].", new Object[]{query.getId(), url, this.totalByteCount.get(), nodeTimeMs, (double)this.totalByteCount.get() / (0.001 * (double)nodeTimeMs)});
                    QueryMetrics responseMetrics = this.acquireResponseMetrics();
                    responseMetrics.reportNodeTime(nodeTimeNs);
                    responseMetrics.reportNodeBytes(this.totalByteCount.get());
                    if (usingBackpressure) {
                        responseMetrics.reportBackPressureTime(this.channelSuspendedTime.get());
                    }
                    responseMetrics.emit(DirectDruidClient.this.emitter);
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        try {
                            this.queue.put(InputStreamHolder.fromChannelBuffer(ChannelBuffers.EMPTY_BUFFER, Long.MAX_VALUE));
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e, "Unable to put finalizing input stream into Sequence queue for url [%s]", new Object[]{url});
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                        }
                        finally {
                            this.done.set(true);
                        }
                    }
                    return ClientResponse.finished((Object)((InputStream)clientResponse.getObj()));
                }

                public void exceptionCaught(ClientResponse<InputStream> clientResponse, Throwable e) {
                    String msg = StringUtils.format((String)"Query[%s] url[%s] failed with exception msg [%s]", (Object[])new Object[]{query.getId(), url, e.getMessage()});
                    this.setupResponseReadFailure(msg, e);
                }

                private void setupResponseReadFailure(final String msg, final Throwable th) {
                    this.fail.set(msg);
                    this.queue.clear();
                    this.queue.offer(InputStreamHolder.fromStream(new InputStream(){

                        @Override
                        public int read() throws IOException {
                            if (th != null) {
                                throw new IOException(msg, th);
                            }
                            throw new IOException(msg);
                        }
                    }, -1L, 0L));
                }

                private long checkQueryTimeout() {
                    long timeLeft = timeoutAt - System.currentTimeMillis();
                    if (timeLeft <= 0L) {
                        String msg = StringUtils.format((String)"Query[%s] url[%s] timed out.", (Object[])new Object[]{query.getId(), url});
                        this.setupResponseReadFailure(msg, null);
                        throw new QueryTimeoutException(msg);
                    }
                    return timeLeft;
                }

                private void checkTotalBytesLimit(long bytes) {
                    if (maxScatterGatherBytes < Long.MAX_VALUE && totalBytesGathered.addAndGet(bytes) > maxScatterGatherBytes) {
                        String msg = StringUtils.format((String)"Query[%s] url[%s] max scatter-gather bytes limit reached.", (Object[])new Object[]{query.getId(), url});
                        this.setupResponseReadFailure(msg, null);
                        throw new ResourceLimitExceededException(msg);
                    }
                }
            };
            long timeLeft = timeoutAt - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query[%s] url[%s] timed out.", (Object[])new Object[]{query.getId(), url}));
            }
            this.openConnections.getAndIncrement();
            try {
                future = this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent(this.objectMapper.writeValueAsBytes((Object)Queries.withTimeout((Query)query, (long)timeLeft))).setHeader("Content-Type", this.isSmile ? "application/x-jackson-smile" : "application/json"), (HttpResponseHandler)responseHandler, Duration.millis((long)timeLeft));
            }
            catch (Exception e) {
                this.openConnections.getAndDecrement();
                throw e;
            }
            this.queryWatcher.registerQueryFuture(query, future);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<InputStream>(){

                public void onSuccess(InputStream result) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                }

                public void onFailure(Throwable t) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                    if (future.isCancelled()) {
                        DirectDruidClient.this.cancelQuery(query, cancelUrl);
                    }
                }
            }, (Executor)Execs.directExecutor());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BaseSequence retVal = new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            public JsonParserIterator<T> make() {
                return new JsonParserIterator(queryResultType, (Future<InputStream>)future, url, query, DirectDruidClient.this.host, toolChest.decorateObjectMapper(DirectDruidClient.this.objectMapper, query));
            }

            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseableUtils.closeAndWrapExceptions(iterFromMake);
            }
        });
        if (!isBySegment) {
            retVal = Sequences.map((Sequence)retVal, (Function)toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
        }
        return retVal;
    }

    private void cancelQuery(Query<T> query, String cancelUrl) {
        Runnable cancelRunnable = () -> {
            try {
                ListenableFuture responseFuture = this.httpClient.go(new Request(HttpMethod.DELETE, new URL(cancelUrl)).setContent(this.objectMapper.writeValueAsBytes((Object)query)).setHeader("Content-Type", this.isSmile ? "application/x-jackson-smile" : "application/json"), (HttpResponseHandler)StatusResponseHandler.getInstance(), Duration.standardSeconds((long)1L));
                Runnable checkRunnable = () -> DirectDruidClient.lambda$cancelQuery$0((Future)responseFuture, query);
                this.queryCancellationExecutor.schedule(checkRunnable, 5L, TimeUnit.SECONDS);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Error cancelling query[%s]", new Object[]{query});
            }
        };
        this.queryCancellationExecutor.submit(cancelRunnable);
    }

    public String toString() {
        return "DirectDruidClient{host='" + this.host + '\'' + ", isSmile=" + this.isSmile + '}';
    }

    private static /* synthetic */ void lambda$cancelQuery$0(Future responseFuture, Query query) {
        try {
            StatusResponseHolder response;
            if (!responseFuture.isDone()) {
                log.error("Error cancelling query[%s]", new Object[]{query});
            }
            if ((response = (StatusResponseHolder)responseFuture.get(30L, TimeUnit.SECONDS)).getStatus().getCode() >= 500) {
                log.error("Error cancelling query[%s]: queriable node returned status[%d] [%s].", new Object[]{query, response.getStatus().getCode(), response.getStatus().getReasonPhrase()});
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Throwable)e, "Error cancelling query[%s]", new Object[]{query});
        }
        catch (TimeoutException e) {
            log.error((Throwable)e, "Timed out cancelling query[%s]", new Object[]{query});
        }
    }
}

