/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.List;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.java.util.common.IAE;

public abstract class BaseTableFunction
implements TableFunction {
    private final List<TableFunction.ParameterDefn> parameters;

    public BaseTableFunction(List<TableFunction.ParameterDefn> parameters) {
        this.parameters = parameters;
    }

    @Override
    public List<TableFunction.ParameterDefn> parameters() {
        return this.parameters;
    }

    protected static void requireSchema(String fnName, List<ColumnSpec> columns) {
        if (columns == null) {
            throw new IAE("Function requires a schema: TABLE(%s(...)) (<col> <type>...)", new Object[]{fnName});
        }
    }

    public static class Parameter
    implements TableFunction.ParameterDefn {
        private final String name;
        private final TableFunction.ParameterType type;
        private final boolean optional;

        public Parameter(String name, TableFunction.ParameterType type, boolean optional) {
            this.name = name;
            this.type = type;
            this.optional = optional;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public TableFunction.ParameterType type() {
            return this.type;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "Parameter{name=" + this.name + ", type=" + (Object)((Object)this.type) + ", optional=" + this.optional + "}";
        }
    }
}

