/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.LongNumericColumnSupplier;
import org.apache.druid.segment.serde.Serializer;

public class LongNumericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    @Nullable
    private final Serializer serializer;

    @JsonCreator
    public static LongNumericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new LongNumericColumnPartSerde(byteOrder, null);
    }

    private LongNumericColumnPartSerde(ByteOrder byteOrder, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig, parent) -> {
            CompressedColumnarLongsSupplier column = CompressedColumnarLongsSupplier.fromByteBuffer(buffer, this.byteOrder);
            LongNumericColumnSupplier columnSupplier = new LongNumericColumnSupplier(column, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
            builder.setType(ValueType.LONG).setHasMultipleValues(false).setNumericColumnSupplier(columnSupplier);
        };
    }

    public static class SerializerBuilder {
        @Nullable
        private ByteOrder byteOrder = null;
        @Nullable
        private Serializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(Serializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public LongNumericColumnPartSerde build() {
            return new LongNumericColumnPartSerde(this.byteOrder, this.delegate);
        }
    }
}

