/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Order;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class ScanQueryEngine {
    public Sequence<ScanResultValue> process(final ScanQuery query, Segment segment, final ResponseContext responseContext, @Nullable QueryMetrics<?> queryMetrics) {
        Long numScannedRows = responseContext.getRowScanCount();
        if (numScannedRows != null && numScannedRows >= query.getScanRowsLimit() && query.getTimeOrder().equals((Object)Order.NONE)) {
            return Sequences.empty();
        }
        if (segment.isTombstone()) {
            return Sequences.empty();
        }
        final boolean hasTimeout = query.context().hasTimeout();
        final Long timeoutAt = responseContext.getTimeoutTime();
        CursorFactory cursorFactory = segment.asCursorFactory();
        if (cursorFactory == null) {
            throw new ISE("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final ArrayList<String> allColumns = new ArrayList<String>();
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            allColumns.addAll(query.getColumns());
        } else {
            LinkedHashSet availableColumns = Sets.newLinkedHashSet((Iterable)Iterables.concat(cursorFactory.getRowSignature().getColumnNames(), (Iterable)Iterables.transform(Arrays.asList(query.getVirtualColumns().getVirtualColumns()), VirtualColumn::getOutputName)));
            allColumns.addAll(availableColumns);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", intervals);
        final SegmentId segmentId = segment.getId();
        responseContext.addRowScanCount(0L);
        final long limit = this.calculateRemainingScanRowsLimit(query, responseContext);
        final CursorHolder cursorHolder = cursorFactory.makeCursorHolder(ScanQueryEngine.makeCursorBuildSpec(query, queryMetrics));
        if (Order.NONE != query.getTimeOrder() && Cursors.getTimeOrdering(cursorHolder.getOrdering()) != query.getTimeOrder()) {
            String failureReason = StringUtils.format("Cannot order by[%s] with direction[%s] on cursor with order[%s].", new Object[]{"__time", query.getTimeOrder(), cursorHolder.getOrdering()});
            cursorHolder.close();
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("%s", failureReason);
        }
        return new BaseSequence<ScanResultValue, Iterator<ScanResultValue>>(new BaseSequence.IteratorMaker<ScanResultValue, Iterator<ScanResultValue>>(){

            @Override
            public Iterator<ScanResultValue> make() {
                final Cursor cursor = cursorHolder.asCursor();
                if (cursor == null) {
                    return Collections.emptyIterator();
                }
                final ArrayList<ColumnValueSelector> columnSelectors = new ArrayList<ColumnValueSelector>(allColumns.size());
                final RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                for (String column : allColumns) {
                    ColumnValueSelector selector = factory.makeColumnValueSelector(column);
                    ColumnCapabilities columnCapabilities = factory.getColumnCapabilities(column);
                    rowSignatureBuilder.add(column, ColumnType.fromCapabilities(columnCapabilities));
                    columnSelectors.add(selector);
                }
                final int batchSize = query.getBatchSize();
                return new Iterator<ScanResultValue>(){
                    private long offset = 0L;

                    @Override
                    public boolean hasNext() {
                        return !cursor.isDone() && this.offset < limit;
                    }

                    @Override
                    public ScanResultValue next() {
                        List<Object> events;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (hasTimeout && System.currentTimeMillis() >= timeoutAt) {
                            throw new QueryTimeoutException(StringUtils.nonStrictFormat("Query [%s] timed out", query.getId()));
                        }
                        long lastOffset = this.offset;
                        ScanQuery.ResultFormat resultFormat = query.getResultFormat();
                        if (ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToCompactedList();
                        } else if (ScanQuery.ResultFormat.RESULT_FORMAT_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToList();
                        } else {
                            throw new UOE("resultFormat[%s] is not supported", resultFormat.toString());
                        }
                        responseContext.addRowScanCount(this.offset - lastOffset);
                        return new ScanResultValue(segmentId.toString(), allColumns, events, rowSignatureBuilder.build());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private List<List<Object>> rowsToCompactedList() {
                        ArrayList<List<Object>> events = new ArrayList<List<Object>>(batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            ArrayList<Object> theEvent = new ArrayList<Object>(allColumns.size());
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.add(this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private List<Map<String, Object>> rowsToList() {
                        ArrayList events = Lists.newArrayListWithCapacity((int)batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            LinkedHashMap<String, Object> theEvent = new LinkedHashMap<String, Object>();
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.put((String)allColumns.get(j), this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private Object getColumnValue(int i) {
                        BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)columnSelectors.get(i);
                        Object value = selector == null ? null : selector.getObject();
                        return value;
                    }
                };
            }

            @Override
            public void cleanup(Iterator<ScanResultValue> iterFromMake) {
            }
        }).withBaggage(cursorHolder);
    }

    private long calculateRemainingScanRowsLimit(ScanQuery query, ResponseContext responseContext) {
        if (query.getTimeOrder().equals((Object)Order.NONE)) {
            return query.getScanRowsLimit() - responseContext.getRowScanCount();
        }
        return query.getScanRowsLimit();
    }

    public static CursorBuildSpec makeCursorBuildSpec(ScanQuery query, @Nullable QueryMetrics<?> queryMetrics) {
        return CursorBuildSpec.builder().setInterval(query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()))).setVirtualColumns(query.getVirtualColumns()).setPreferredOrdering(query.getOrderBys()).setQueryContext(query.context()).setQueryMetrics(queryMetrics).build();
    }
}

