/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.NullColumn;
import org.apache.druid.segment.column.ColumnType;

public class ConcatRowsAndColumns
implements RowsAndColumns {
    private final ArrayList<RowsAndColumns> racBuffer;
    private final Map<String, Column> columnCache = new LinkedHashMap<String, Column>();
    private final int[][] rowPointers;
    private final int numRows;

    public ConcatRowsAndColumns(ArrayList<RowsAndColumns> racBuffer) {
        Preconditions.checkNotNull(racBuffer, (Object)"racBuffer cannot be null");
        this.racBuffer = racBuffer;
        int numRows = 0;
        for (RowsAndColumns rac : racBuffer) {
            numRows += rac.numRows();
        }
        this.numRows = numRows;
        this.rowPointers = new int[2][numRows];
        int index = 0;
        for (int i = 0; i < racBuffer.size(); ++i) {
            RowsAndColumns rac = racBuffer.get(i);
            Arrays.fill(this.rowPointers[0], index, index + rac.numRows(), i);
            for (int j = 0; j < rac.numRows(); ++j) {
                this.rowPointers[1][index + j] = j;
            }
            index += rac.numRows();
        }
    }

    @Override
    public Collection<String> getColumnNames() {
        if (this.racBuffer.isEmpty()) {
            return Collections.emptySet();
        }
        return this.racBuffer.get(0).getColumnNames();
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (this.columnCache.containsKey(name)) {
            return this.columnCache.get(name);
        }
        if (this.racBuffer.isEmpty()) {
            return null;
        }
        Column firstCol = this.racBuffer.get(0).findColumn(name);
        if (firstCol == null) {
            for (int i = 1; i < this.racBuffer.size(); ++i) {
                RowsAndColumns rac = this.racBuffer.get(i);
                if (rac.findColumn(name) == null) continue;
                throw new ISE("Column[%s] was not always null...", name);
            }
            this.columnCache.put(name, null);
            return null;
        }
        ArrayList<ColumnAccessor> accessors = new ArrayList<ColumnAccessor>(this.racBuffer.size());
        ColumnAccessor firstAccessor = firstCol.toAccessor();
        accessors.add(firstAccessor);
        ColumnType type = firstAccessor.getType();
        for (int i = 1; i < this.racBuffer.size(); ++i) {
            ColumnAccessor accessor;
            RowsAndColumns rac = this.racBuffer.get(i);
            Column col = rac.findColumn(name);
            if (col == null) {
                col = new NullColumn(type, rac.numRows());
            }
            if (!type.equals((accessor = col.toAccessor()).getType())) {
                throw new ISE("Type mismatch, expected[%s], got[%s] on entry[%,d]", type, accessor.getType(), i);
            }
            accessors.add(accessor);
        }
        ConcatedidColumn retVal = new ConcatedidColumn(type, Comparator.nullsFirst(type.getStrategy()), accessors);
        this.columnCache.put(name, retVal);
        return retVal;
    }

    private class ConcatedidColumn
    implements Column {
        private final ArrayList<ColumnAccessor> accessors;
        private final ColumnType type;
        private final Comparator<Object> comp;

        public ConcatedidColumn(ColumnType type, Comparator<Object> comp, ArrayList<ColumnAccessor> accessors) {
            this.accessors = accessors;
            this.type = type;
            this.comp = comp;
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ColumnAccessor(){

                @Override
                public ColumnType getType() {
                    return ConcatedidColumn.this.type;
                }

                @Override
                public int numRows() {
                    return ConcatRowsAndColumns.this.numRows;
                }

                @Override
                public boolean isNull(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.isNull(localIndex);
                }

                @Override
                @Nullable
                public Object getObject(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.getObject(localIndex);
                }

                @Override
                public double getDouble(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.getDouble(localIndex);
                }

                @Override
                public float getFloat(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.getFloat(localIndex);
                }

                @Override
                public long getLong(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.getLong(localIndex);
                }

                @Override
                public int getInt(int rowNum) {
                    ColumnAccessor localAccessor = this.getLocalAccessor(rowNum);
                    int localIndex = this.getLocalIndex(rowNum);
                    return localAccessor.getInt(localIndex);
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    ColumnAccessor lhsAccessor = this.getLocalAccessor(lhsRowNum);
                    int lhsIndex = this.getLocalIndex(lhsRowNum);
                    ColumnAccessor rhsAccessor = this.getLocalAccessor(rhsRowNum);
                    int rhsIndex = this.getLocalIndex(rhsRowNum);
                    return ConcatedidColumn.this.comp.compare(lhsAccessor.getObject(lhsIndex), rhsAccessor.getObject(rhsIndex));
                }

                private int getLocalIndex(int rowNum) {
                    return ConcatRowsAndColumns.this.rowPointers[1][rowNum];
                }

                private ColumnAccessor getLocalAccessor(int rowNum) {
                    return (ColumnAccessor)ConcatedidColumn.this.accessors.get(ConcatRowsAndColumns.this.rowPointers[0][rowNum]);
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }
}

