/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.NaiveSortOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;

public class NaiveSortOperatorFactory
implements OperatorFactory {
    private final List<ColumnWithDirection> sortColumns;

    @JsonCreator
    public NaiveSortOperatorFactory(@JsonProperty(value="columns") List<ColumnWithDirection> sortColumns) {
        this.sortColumns = sortColumns;
    }

    @JsonProperty(value="columns")
    public List<ColumnWithDirection> getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public Operator wrap(Operator op) {
        return new NaiveSortOperator(op, this.sortColumns);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        if (other instanceof NaiveSortOperatorFactory) {
            return this.sortColumns.equals(((NaiveSortOperatorFactory)other).getSortColumns());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sortColumns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NaiveSortOperatorFactory other = (NaiveSortOperatorFactory)obj;
        return Objects.equals(this.sortColumns, other.sortColumns);
    }

    public String toString() {
        return "NaiveSortOperatorFactory{sortColumns=" + this.sortColumns + "}";
    }
}

