/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.NaiveSortMaker;

public class NaiveSortOperator
implements Operator {
    private final Operator child;
    private final List<ColumnWithDirection> sortColumns;

    public NaiveSortOperator(Operator child, List<ColumnWithDirection> sortColumns) {
        this.child = child;
        this.sortColumns = sortColumns;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, final Operator.Receiver receiver) {
        return this.child.goOrContinue(continuation, new Operator.Receiver(){
            NaiveSortMaker.NaiveSorter sorter = null;

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                if (this.sorter == null) {
                    this.sorter = NaiveSortMaker.fromRAC(rac).make(new ArrayList<ColumnWithDirection>(NaiveSortOperator.this.sortColumns));
                } else {
                    this.sorter.moreData(rac);
                }
                return Operator.Signal.GO;
            }

            @Override
            public void completed() {
                if (this.sorter != null) {
                    receiver.push(this.sorter.complete());
                }
                receiver.completed();
            }
        });
    }
}

