/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;

public final class ImmutableLookupMap
extends ForwardingMap<String, String> {
    private static final int NOT_FOUND = -1;
    private static final float LOAD_FACTOR = 0.6f;
    private static final Comparator<Pair<String, String>> VALUE_COMPARATOR = Comparator.comparing(pair -> (String)pair.rhs, Comparators.naturalNullsFirst());
    private final Object2IntMap<String> keyToEntry;
    private final List<String> keys;
    private final List<String> values;
    private final Map<String, String> asMap;

    private ImmutableLookupMap(Object2IntMap<String> keyToEntry, List<String> keys, List<String> values) {
        this.keyToEntry = (Object2IntMap)Preconditions.checkNotNull(keyToEntry, (Object)"keyToEntry");
        this.keys = (List)Preconditions.checkNotNull(keys, (Object)"keys");
        this.values = (List)Preconditions.checkNotNull(values, (Object)"values");
        this.asMap = Collections.unmodifiableMap(Maps.transformValues(keyToEntry, values::get));
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLookupMap fromMap(Map<String, String> srcMap) {
        void var5_7;
        ArrayList<Pair<String, String>> entriesList = new ArrayList<Pair<String, String>>(srcMap.size());
        for (Map.Entry<String, String> entry : srcMap.entrySet()) {
            entriesList.add(Pair.of(entry.getKey(), entry.getValue()));
        }
        entriesList.sort(VALUE_COMPARATOR);
        ArrayList<String> keys = new ArrayList<String>(entriesList.size());
        ArrayList<String> values = new ArrayList<String>(entriesList.size());
        for (Pair pair : entriesList) {
            keys.add((String)pair.lhs);
            values.add((String)pair.rhs);
        }
        entriesList.clear();
        Object2IntOpenHashMap keyToEntry = new Object2IntOpenHashMap(keys.size(), 0.6f);
        keyToEntry.defaultReturnValue(-1);
        boolean bl = false;
        while (var5_7 < keys.size()) {
            keyToEntry.put((Object)((String)keys.get((int)var5_7)), (int)var5_7);
            ++var5_7;
        }
        return new ImmutableLookupMap((Object2IntMap<String>)keyToEntry, keys, values);
    }

    protected Map<String, String> delegate() {
        return this.asMap;
    }

    public LookupExtractor asLookupExtractor(boolean isOneToOne, Supplier<byte[]> cacheKey) {
        return new ImmutableLookupExtractor(isOneToOne, cacheKey);
    }

    public class ImmutableLookupExtractor
    extends LookupExtractor {
        private final boolean isOneToOne;
        private final Supplier<byte[]> cacheKeySupplier;

        private ImmutableLookupExtractor(boolean isOneToOne, Supplier<byte[]> cacheKeySupplier) {
            this.isOneToOne = isOneToOne;
            this.cacheKeySupplier = (Supplier)Preconditions.checkNotNull(cacheKeySupplier, (Object)"cacheKeySupplier");
        }

        @Override
        @Nullable
        public String apply(@Nullable String key) {
            String keyEquivalent = NullHandling.nullToEmptyIfNeeded(key);
            if (keyEquivalent == null) {
                return null;
            }
            int entryId = ImmutableLookupMap.this.keyToEntry.getInt((Object)keyEquivalent);
            if (entryId == -1) {
                return null;
            }
            return NullHandling.emptyToNullIfNeeded((String)ImmutableLookupMap.this.values.get(entryId));
        }

        @Override
        protected List<String> unapply(@Nullable String value) {
            List<String> emptyStringUnapplied;
            List<String> unapplied = this.unapplyInternal(value, !NullHandling.sqlCompatible());
            if (NullHandling.replaceWithDefault() && value == null && !(emptyStringUnapplied = this.unapplyInternal("", true)).isEmpty()) {
                ArrayList<String> combined = new ArrayList<String>(unapplied.size() + emptyStringUnapplied.size());
                combined.addAll(unapplied);
                combined.addAll(emptyStringUnapplied);
                return combined;
            }
            return unapplied;
        }

        @Override
        public boolean supportsAsMap() {
            return true;
        }

        @Override
        public Map<String, String> asMap() {
            return ImmutableLookupMap.this.asMap;
        }

        @Override
        public boolean isOneToOne() {
            return this.isOneToOne;
        }

        @Override
        public long estimateHeapFootprint() {
            return MapLookupExtractor.estimateHeapFootprint(this.asMap().entrySet());
        }

        @Override
        public byte[] getCacheKey() {
            return this.cacheKeySupplier.get();
        }

        private List<String> unapplyInternal(@Nullable String value, boolean includeNullKeys) {
            int minIndex;
            int index = Collections.binarySearch(ImmutableLookupMap.this.values, value, Comparators.naturalNullsFirst());
            if (index < 0) {
                return Collections.emptyList();
            }
            int maxIndex = index + 1;
            for (minIndex = index; minIndex > 0 && Objects.equals(ImmutableLookupMap.this.values.get(minIndex - 1), value); --minIndex) {
            }
            while (maxIndex < ImmutableLookupMap.this.values.size() && Objects.equals(ImmutableLookupMap.this.values.get(maxIndex), value)) {
                ++maxIndex;
            }
            if (minIndex + 1 == maxIndex) {
                String key = (String)ImmutableLookupMap.this.keys.get(index);
                if (key == null && !includeNullKeys) {
                    return Collections.emptyList();
                }
                return Collections.singletonList((String)ImmutableLookupMap.this.keys.get(index));
            }
            ArrayList<String> retVal = new ArrayList<String>(maxIndex - minIndex);
            for (int i = minIndex; i < maxIndex; ++i) {
                String key = (String)ImmutableLookupMap.this.keys.get(i);
                if (key == null && !includeNullKeys) continue;
                retVal.add(key);
            }
            return retVal;
        }
    }
}

