/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.FirstLastVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.SelectionPredicate;
import org.apache.druid.query.aggregation.firstlast.StringFirstLastUtils;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class StringFirstLastVectorAggregator
extends FirstLastVectorAggregator<String, SerializablePairLongString> {
    private final int maxStringBytes;
    private final SelectionPredicate selectionPredicate;

    protected StringFirstLastVectorAggregator(@Nullable VectorValueSelector timeSelector, VectorObjectSelector objectSelector, int maxStringBytes, SelectionPredicate selectionPredicate) {
        super(timeSelector, null, objectSelector, selectionPredicate);
        this.maxStringBytes = maxStringBytes;
        this.selectionPredicate = selectionPredicate;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(this.selectionPredicate.initValue(), null), this.maxStringBytes);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return StringFirstLastUtils.readPair(buf, position);
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, String value) {
        StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, value), this.maxStringBytes);
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, VectorValueSelector valueSelector, int index) {
        throw DruidException.defensive("This variant is not applicable to the StringFirstLastVectorAggregator", new Object[0]);
    }

    @Override
    protected void putDefaultValue(ByteBuffer buf, int position, long time) {
        StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, NullHandling.defaultStringValue()), this.maxStringBytes);
    }

    @Override
    protected void putNull(ByteBuffer buf, int position, long time) {
        StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, null), this.maxStringBytes);
    }

    @Override
    protected SerializablePairLongString readPairFromVectorSelectors(boolean[] timeNullityVector, long[] timeVector, Object[] maybeFoldedObjects, int index) {
        return StringFirstLastUtils.readPairFromVectorSelectorsAtIndex(timeNullityVector, timeVector, maybeFoldedObjects, index);
    }
}

