/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.DoubleOutDoubleLongInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.DoubleOutDoublesInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.DoubleOutLongDoubleInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongOutDoubleLongInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutDoublesInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutLongDoubleInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutLongsInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutObjectsInFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathProcessors;
import org.apache.druid.segment.column.Types;

public class VectorComparisonProcessors {
    @Deprecated
    public static <T> ExprVectorProcessor<T> makeComparisonProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right, Supplier<LongOutObjectsInFunctionVectorProcessor> longOutStringsInFunctionVectorProcessor, Supplier<LongOutLongsInFunctionVectorValueProcessor> longOutLongsInProcessor, Supplier<DoubleOutLongDoubleInFunctionVectorValueProcessor> doubleOutLongDoubleInProcessor, Supplier<DoubleOutDoubleLongInFunctionVectorValueProcessor> doubleOutDoubleLongInProcessor, Supplier<DoubleOutDoublesInFunctionVectorValueProcessor> doubleOutDoublesInProcessor) {
        assert (!ExpressionProcessing.useStrictBooleans());
        ExpressionType leftType = left.getOutputType(inspector);
        ExpressionType rightType = right.getOutputType(inspector);
        ExprVectorProcessor processor = null;
        if (Types.is(leftType, ExprType.STRING)) {
            processor = Types.isNullOr(rightType, ExprType.STRING) ? (ExprVectorProcessor)longOutStringsInFunctionVectorProcessor.get() : (ExprVectorProcessor)doubleOutDoublesInProcessor.get();
        } else if (leftType == null) {
            if (Types.isNullOr(rightType, ExprType.STRING)) {
                processor = longOutStringsInFunctionVectorProcessor.get();
            }
        } else if (leftType.is(ExprType.DOUBLE) || Types.is(rightType, ExprType.DOUBLE)) {
            processor = doubleOutDoublesInProcessor.get();
        }
        if (processor != null) {
            return processor;
        }
        return VectorMathProcessors.makeMathProcessor(inspector, left, right, longOutLongsInProcessor, doubleOutLongDoubleInProcessor, doubleOutDoubleLongInProcessor, doubleOutDoublesInProcessor);
    }

    public static <T> ExprVectorProcessor<T> makeBooleanProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right, Supplier<LongOutObjectsInFunctionVectorProcessor> longOutStringsInFunctionVectorProcessor, Supplier<LongOutLongsInFunctionVectorValueProcessor> longOutLongsInProcessor, Supplier<LongOutLongDoubleInFunctionVectorValueProcessor> longOutLongDoubleInProcessor, Supplier<LongOutDoubleLongInFunctionVectorValueProcessor> longOutDoubleLongInProcessor, Supplier<LongOutDoublesInFunctionVectorValueProcessor> longOutDoublesInProcessor) {
        ExpressionType leftType = left.getOutputType(inspector);
        ExpressionType rightType = right.getOutputType(inspector);
        ExprVectorProcessor processor = null;
        if (Types.is(leftType, ExprType.STRING)) {
            processor = Types.isNullOr(rightType, ExprType.STRING) ? (ExprVectorProcessor)longOutStringsInFunctionVectorProcessor.get() : (ExprVectorProcessor)longOutDoublesInProcessor.get();
        } else if (Types.is(rightType, ExprType.STRING)) {
            processor = leftType == null ? (ExprVectorProcessor)longOutStringsInFunctionVectorProcessor.get() : (ExprVectorProcessor)longOutDoublesInProcessor.get();
        } else if (leftType == null) {
            if (Types.isNullOr(rightType, ExprType.STRING)) {
                processor = longOutStringsInFunctionVectorProcessor.get();
            }
        } else if (leftType.is(ExprType.DOUBLE) || Types.is(rightType, ExprType.DOUBLE)) {
            processor = longOutDoublesInProcessor.get();
        }
        if (processor != null) {
            return processor;
        }
        return VectorMathProcessors.makeLongMathProcessor(inspector, left, right, longOutLongsInProcessor, longOutLongDoubleInProcessor, longOutDoubleLongInProcessor, longOutDoublesInProcessor);
    }

    public static <T> ExprVectorProcessor<T> equal(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(Objects.equals(leftVal, rightVal));
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left == right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble((double)left == right);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(left == (double)right);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(left == right);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(Objects.equals(leftVal, rightVal));
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left == right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong((double)left == right);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(left == (double)right);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(left == right);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> notEqual(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(!Objects.equals(leftVal, rightVal));
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left != right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble((double)left != right);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(left != (double)right);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(left != right);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(!Objects.equals(leftVal, rightVal));
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left != right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong((double)left != right);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(left != (double)right);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(left != right);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> greaterThanOrEqual(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) >= 0);
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left >= right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble(Double.compare(left, right) >= 0);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(Double.compare(left, right) >= 0);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(Double.compare(left, right) >= 0);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) >= 0);
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left >= right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong(Double.compare(left, right) >= 0);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(Double.compare(left, right) >= 0);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(Double.compare(left, right) >= 0);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> greaterThan(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) > 0);
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left > right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble(Double.compare(left, right) > 0);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(Double.compare(left, right) > 0);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(Double.compare(left, right) > 0);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) > 0);
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left > right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong(Double.compare(left, right) > 0);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(Double.compare(left, right) > 0);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(Double.compare(left, right) > 0);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> lessThanOrEqual(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) <= 0);
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left <= right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble(Double.compare(left, right) <= 0);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(Double.compare(left, right) <= 0);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(Double.compare(left, right) <= 0);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) <= 0);
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left <= right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong(Double.compare(left, right) <= 0);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(Double.compare(left, right) <= 0);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(Double.compare(left, right) <= 0);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> lessThan(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return VectorComparisonProcessors.makeComparisonProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

                @Override
                @Nullable
                Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                    return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) < 0);
                }
            }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public long apply(long left, long right) {
                    return Evals.asLong(left < right);
                }
            }, () -> new DoubleOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(long left, double right) {
                    return Evals.asDouble(Double.compare(left, right) < 0);
                }
            }, () -> new DoubleOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, long right) {
                    return Evals.asDouble(Double.compare(left, right) < 0);
                }
            }, () -> new DoubleOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

                @Override
                public double apply(double left, double right) {
                    return Evals.asDouble(Double.compare(left, right) < 0);
                }
            });
        }
        return VectorComparisonProcessors.makeBooleanProcessor(inspector, left, right, () -> new LongOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            Long processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return Evals.asLong(Comparators.naturalNullsFirst().compare((Object)((String)leftVal), (Object)((String)rightVal)) < 0);
            }
        }, () -> new LongOutLongsInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, long right) {
                return Evals.asLong(left < right);
            }
        }, () -> new LongOutLongDoubleInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(long left, double right) {
                return Evals.asLong(Double.compare(left, right) < 0);
            }
        }, () -> new LongOutDoubleLongInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, long right) {
                return Evals.asLong(Double.compare(left, right) < 0);
            }
        }, () -> new LongOutDoublesInFunctionVectorValueProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize()){

            @Override
            public long apply(double left, double right) {
                return Evals.asLong(Double.compare(left, right) < 0);
            }
        });
    }

    private VectorComparisonProcessors() {
    }
}

