/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ApplyFunction;
import org.apache.druid.math.expr.ApplyFunctionExpr;
import org.apache.druid.math.expr.ArrayExpr;
import org.apache.druid.math.expr.BigIntegerExpr;
import org.apache.druid.math.expr.BinAndExpr;
import org.apache.druid.math.expr.BinDivExpr;
import org.apache.druid.math.expr.BinEqExpr;
import org.apache.druid.math.expr.BinGeqExpr;
import org.apache.druid.math.expr.BinGtExpr;
import org.apache.druid.math.expr.BinLeqExpr;
import org.apache.druid.math.expr.BinLtExpr;
import org.apache.druid.math.expr.BinMinusExpr;
import org.apache.druid.math.expr.BinModuloExpr;
import org.apache.druid.math.expr.BinMulExpr;
import org.apache.druid.math.expr.BinNeqExpr;
import org.apache.druid.math.expr.BinOrExpr;
import org.apache.druid.math.expr.BinPlusExpr;
import org.apache.druid.math.expr.BinPowExpr;
import org.apache.druid.math.expr.DoubleExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.FunctionExpr;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.LambdaExpr;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.StringExpr;
import org.apache.druid.math.expr.UnaryMinusExpr;
import org.apache.druid.math.expr.UnaryNotExpr;
import org.apache.druid.math.expr.antlr.ExprBaseListener;
import org.apache.druid.math.expr.antlr.ExprParser;

public class ExprListenerImpl
extends ExprBaseListener {
    private final Map<ParseTree, Object> nodes;
    private final ExprMacroTable macroTable;
    private final ParseTree rootNodeKey;
    private final Set<String> lambdaIdentifiers;
    private final Set<String> uniqueIdentifiers;
    private int uniqueCounter = 0;

    ExprListenerImpl(ParseTree rootNodeKey, ExprMacroTable macroTable) {
        this.rootNodeKey = rootNodeKey;
        this.macroTable = macroTable;
        this.nodes = new HashMap<ParseTree, Object>();
        this.lambdaIdentifiers = new HashSet<String>();
        this.uniqueIdentifiers = new HashSet<String>();
    }

    Expr getAST() {
        return (Expr)this.nodes.get(this.rootNodeKey);
    }

    @Override
    public void exitUnaryOpExpr(ExprParser.UnaryOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(0)).getSymbol().getType();
        switch (opCode) {
            case 18: {
                this.nodes.put((ParseTree)ctx, new UnaryMinusExpr(ctx.getChild(0).getText(), (Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            case 19: {
                this.nodes.put((ParseTree)ctx, new UnaryNotExpr(ctx.getChild(0).getText(), (Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            default: {
                throw new RE("Unrecognized unary operator %s", ctx.getChild(0).getText());
            }
        }
    }

    @Override
    public void exitApplyFunctionExpr(ExprParser.ApplyFunctionExprContext ctx) {
        String fnName = ctx.getChild(0).getText();
        ApplyFunction function = Parser.getApplyFunction(fnName);
        if (function == null) {
            throw new RE("function '%s' is not defined.", fnName);
        }
        this.nodes.put((ParseTree)ctx, new ApplyFunctionExpr(function, fnName, (LambdaExpr)this.nodes.get((Object)ctx.lambda()), (List)this.nodes.get((Object)ctx.fnArgs())));
    }

    @Override
    public void exitDoubleExpr(ExprParser.DoubleExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new DoubleExpr(Double.parseDouble(ctx.getText())));
    }

    @Override
    public void exitAddSubExpr(ExprParser.AddSubExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 24: {
                this.nodes.put((ParseTree)ctx, new BinPlusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 18: {
                this.nodes.put((ParseTree)ctx, new BinMinusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RE("Unrecognized binary operator %s", ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitLongExpr(ExprParser.LongExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new BigIntegerExpr(new BigInteger(ctx.getText())));
    }

    @Override
    public void exitLogicalAndOrExpr(ExprParser.LogicalAndOrExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 31: {
                this.nodes.put((ParseTree)ctx, new BinAndExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 32: {
                this.nodes.put((ParseTree)ctx, new BinOrExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RE("Unrecognized binary operator %s", ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitNestedExpr(ExprParser.NestedExprContext ctx) {
        this.nodes.put((ParseTree)ctx, this.nodes.get(ctx.getChild(1)));
    }

    @Override
    public void exitString(ExprParser.StringContext ctx) {
        this.nodes.put((ParseTree)ctx, new StringExpr(ExprListenerImpl.escapeStringLiteral(ctx.getText())));
    }

    @Override
    public void exitLogicalOpExpr(ExprParser.LogicalOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 25: {
                this.nodes.put((ParseTree)ctx, new BinLtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 26: {
                this.nodes.put((ParseTree)ctx, new BinLeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 27: {
                this.nodes.put((ParseTree)ctx, new BinGtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 28: {
                this.nodes.put((ParseTree)ctx, new BinGeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 29: {
                this.nodes.put((ParseTree)ctx, new BinEqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 30: {
                this.nodes.put((ParseTree)ctx, new BinNeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RE("Unrecognized binary operator %s", ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitMulDivModuloExpr(ExprParser.MulDivModuloExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 21: {
                this.nodes.put((ParseTree)ctx, new BinMulExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 22: {
                this.nodes.put((ParseTree)ctx, new BinDivExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 23: {
                this.nodes.put((ParseTree)ctx, new BinModuloExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RE("Unrecognized binary operator %s", ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitPowOpExpr(ExprParser.PowOpExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new BinPowExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
    }

    @Override
    public void exitFunctionExpr(ExprParser.FunctionExprContext ctx) {
        List args;
        String fnName = ctx.getChild(0).getText();
        Expr expr = this.macroTable.get(fnName, args = ctx.getChildCount() > 3 ? (List)this.nodes.get(ctx.getChild(2)) : Collections.emptyList());
        if (expr == null) {
            Function function = Parser.getFunction(fnName);
            if (function == null) {
                throw new RE("function '%s' is not defined.", fnName);
            }
            expr = new FunctionExpr(function, fnName, args);
        }
        this.nodes.put((ParseTree)ctx, expr);
    }

    @Override
    public void exitIdentifierExpr(ExprParser.IdentifierExprContext ctx) {
        String text = ExprListenerImpl.sanitizeIdentifierString(ctx.getText());
        this.nodes.put((ParseTree)ctx, this.createIdentifierExpr(text));
    }

    @Override
    public void enterLambda(ExprParser.LambdaContext ctx) {
        for (int i = 0; i < ctx.IDENTIFIER().size(); ++i) {
            String text = ctx.IDENTIFIER(i).getText();
            text = ExprListenerImpl.sanitizeIdentifierString(text);
            this.lambdaIdentifiers.add(text);
        }
    }

    @Override
    public void exitLambda(ExprParser.LambdaContext ctx) {
        ArrayList<IdentifierExpr> identifiers = new ArrayList<IdentifierExpr>(ctx.IDENTIFIER().size());
        for (int i = 0; i < ctx.IDENTIFIER().size(); ++i) {
            String text = ctx.IDENTIFIER(i).getText();
            text = ExprListenerImpl.sanitizeIdentifierString(text);
            identifiers.add(i, this.createIdentifierExpr(text));
            this.lambdaIdentifiers.remove(text);
        }
        this.nodes.put((ParseTree)ctx, new LambdaExpr(identifiers, (Expr)this.nodes.get((Object)ctx.expr())));
    }

    @Override
    public void exitFunctionArgs(ExprParser.FunctionArgsContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (ParseTree parseTree : ctx.expr()) {
            args.add((Expr)this.nodes.get(parseTree));
        }
        this.nodes.put((ParseTree)ctx, args);
    }

    @Override
    public void exitNull(ExprParser.NullContext ctx) {
        this.nodes.put((ParseTree)ctx, new StringExpr(null));
    }

    @Override
    public void exitDoubleArray(ExprParser.DoubleArrayContext ctx) {
        Object[] values = new Object[ctx.numericElement().size()];
        for (int i = 0; i < values.length; ++i) {
            if (ctx.numericElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            if (ctx.numericElement(i).LONG() != null) {
                values[i] = Numbers.parseDoubleObject(ctx.numericElement(i).LONG().getText());
                continue;
            }
            if (ctx.numericElement(i).DOUBLE() != null) {
                values[i] = Numbers.parseDoubleObject(ctx.numericElement(i).DOUBLE().getText());
                continue;
            }
            throw new RE("Failed to parse array element %s as a double", ctx.numericElement(i).getText());
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(ExpressionType.DOUBLE_ARRAY, values));
    }

    @Override
    public void exitExplicitArray(ExprParser.ExplicitArrayContext ctx) {
        ExpressionType type = ExpressionType.fromString(ctx.ARRAY_TYPE().getText());
        if (type == null) {
            throw new RE("Failed to convert array type %s to expression type", ctx.ARRAY_TYPE().getText());
        }
        Object[] values = new Object[ctx.literalElement().size()];
        block5: for (int i = 0; i < values.length; ++i) {
            if (ctx.literalElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            ExprParser.LiteralElementContext elementContext = ctx.literalElement(i);
            String toParse = elementContext.STRING() != null ? ExprListenerImpl.escapeStringLiteral(elementContext.STRING().getText()) : elementContext.getText();
            switch ((ExprType)type.getElementType().getType()) {
                case LONG: {
                    values[i] = Numbers.parseLongObject(toParse);
                    continue block5;
                }
                case DOUBLE: {
                    values[i] = Numbers.parseDoubleObject(toParse);
                    continue block5;
                }
                case STRING: {
                    values[i] = toParse;
                    continue block5;
                }
                default: {
                    throw new RE("Failed to parse array element %s as a %s", toParse, type.getElementType().asTypeString());
                }
            }
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(type, values));
    }

    @Override
    public void exitLongArray(ExprParser.LongArrayContext ctx) {
        Object[] values = new Object[ctx.longElement().size()];
        for (int i = 0; i < values.length; ++i) {
            if (ctx.longElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            if (ctx.longElement(i).LONG() != null) {
                values[i] = Long.parseLong(ctx.longElement(i).LONG().getText());
                continue;
            }
            throw new RE("Failed to parse array element %s as a long", ctx.longElement(i).getText());
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(ExpressionType.LONG_ARRAY, values));
    }

    @Override
    public void exitExplicitLongArray(ExprParser.ExplicitLongArrayContext ctx) {
        Object[] values = new Object[ctx.numericElement().size()];
        for (int i = 0; i < values.length; ++i) {
            if (ctx.numericElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            if (ctx.numericElement(i).LONG() != null) {
                values[i] = Numbers.parseLongObject(ctx.numericElement(i).LONG().getText());
                continue;
            }
            if (ctx.numericElement(i).DOUBLE() != null) {
                values[i] = Numbers.parseLongObject(ctx.numericElement(i).DOUBLE().getText());
                continue;
            }
            throw new RE("Failed to parse array element %s as a long", ctx.numericElement(i).getText());
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(ExpressionType.LONG_ARRAY, values));
    }

    @Override
    public void exitStringArray(ExprParser.StringArrayContext ctx) {
        Object[] values = new Object[ctx.stringElement().size()];
        for (int i = 0; i < values.length; ++i) {
            if (ctx.stringElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            if (ctx.stringElement(i).STRING() != null) {
                values[i] = ExprListenerImpl.escapeStringLiteral(ctx.stringElement(i).STRING().getText());
                continue;
            }
            throw new RE("Failed to parse array: element %s is not a string", ctx.stringElement(i).getText());
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(ExpressionType.STRING_ARRAY, values));
    }

    @Override
    public void exitExplicitStringArray(ExprParser.ExplicitStringArrayContext ctx) {
        Object[] values = new Object[ctx.literalElement().size()];
        for (int i = 0; i < values.length; ++i) {
            if (ctx.literalElement(i).NULL() != null) {
                values[i] = null;
                continue;
            }
            if (ctx.literalElement(i).STRING() != null) {
                values[i] = ExprListenerImpl.escapeStringLiteral(ctx.literalElement(i).STRING().getText());
                continue;
            }
            if (ctx.literalElement(i).DOUBLE() != null) {
                values[i] = ctx.literalElement(i).DOUBLE().getText();
                continue;
            }
            if (ctx.literalElement(i).LONG() != null) {
                values[i] = ctx.literalElement(i).LONG().getText();
                continue;
            }
            throw new RE("Failed to parse array element %s as a string", ctx.literalElement(i).getText());
        }
        this.nodes.put((ParseTree)ctx, new ArrayExpr(ExpressionType.STRING_ARRAY, values));
    }

    private IdentifierExpr createIdentifierExpr(String binding) {
        if (!this.lambdaIdentifiers.contains(binding)) {
            String uniqueIdentifier = binding;
            while (this.uniqueIdentifiers.contains(uniqueIdentifier)) {
                uniqueIdentifier = StringUtils.format("%s_%s", binding, this.uniqueCounter++);
            }
            this.uniqueIdentifiers.add(uniqueIdentifier);
            return new IdentifierExpr(uniqueIdentifier, binding);
        }
        return new IdentifierExpr(binding);
    }

    private static String sanitizeIdentifierString(String text) {
        if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            text = StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1));
        }
        return text;
    }

    @Nullable
    private static String escapeStringLiteral(String text) {
        if (text.equalsIgnoreCase("null")) {
            return null;
        }
        String unquoted = text.substring(1, text.length() - 1);
        return unquoted.indexOf(92) >= 0 ? StringEscapeUtils.unescapeJava((String)unquoted) : unquoted;
    }
}

