/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.BinaryBooleanOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorComparisonProcessors;

class BinNeqExpr
extends BinaryBooleanOpExprBase {
    BinNeqExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinNeqExpr(this.op, left, right);
    }

    @Override
    protected boolean evalString(@Nullable String left, @Nullable String right) {
        return !Objects.equals(left, right);
    }

    @Override
    protected boolean evalArray(ExprEval left, ExprEval right) {
        ExpressionType type = ExpressionTypeConversion.leastRestrictiveType(left.type(), right.type());
        return type.getNullableStrategy().compare(left.castTo(type).asArray(), right.castTo(type).asArray()) != 0;
    }

    @Override
    protected final boolean evalLong(long left, long right) {
        return left != right;
    }

    @Override
    protected final boolean evalDouble(double left, double right) {
        return left != right;
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorComparisonProcessors.notEqual(inspector, this.left, this.right);
    }
}

