/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class Disk {
    private static final Logger LOG = new Logger(Disk.class);
    private static final String CGROUP = "blkio";
    private static final String IO_SERVICED_FILE = "blkio.throttle.io_serviced";
    private static final String IO_SERVICE_BYTES_FILE = "blkio.throttle.io_service_bytes";
    private static final String READ = "Read";
    private static final String WRITE = "Write";
    private final CgroupDiscoverer cgroupDiscoverer;

    public Disk(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public Map<String, Metrics> snapshot() {
        Metrics metrics;
        String[] parts;
        String line;
        BufferedReader reader;
        HashMap<String, Metrics> statsByDisk = new HashMap<String, Metrics>();
        try {
            reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), IO_SERVICED_FILE));
            try {
                line = reader.readLine();
                while (line != null) {
                    parts = line.split(Pattern.quote(" "));
                    if (parts.length == 3) {
                        metrics = statsByDisk.computeIfAbsent(parts[0], majorMinor -> new Metrics((String)majorMinor));
                        switch (parts[1]) {
                            case "Write": {
                                metrics.writeCount = Longs.tryParse((String)parts[2]);
                                break;
                            }
                            case "Read": {
                                metrics.readCount = Longs.tryParse((String)parts[2]);
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch disk snapshot", new Object[0]);
        }
        try {
            reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), IO_SERVICE_BYTES_FILE));
            try {
                line = reader.readLine();
                while (line != null) {
                    parts = line.split(Pattern.quote(" "));
                    if (parts.length == 3) {
                        metrics = statsByDisk.computeIfAbsent(parts[0], majorMinor -> new Metrics((String)majorMinor));
                        switch (parts[1]) {
                            case "Write": {
                                metrics.writeBytes = Longs.tryParse((String)parts[2]);
                                break;
                            }
                            case "Read": {
                                metrics.readBytes = Longs.tryParse((String)parts[2]);
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch memory snapshot", new Object[0]);
        }
        return statsByDisk;
    }

    public static class Metrics {
        String diskName;
        long readCount;
        long writeCount;
        long readBytes;
        long writeBytes;

        public Metrics(String majorMinor) {
            try {
                File deviceFile = new File("/sys/dev/block/" + majorMinor);
                if (deviceFile.exists()) {
                    this.diskName = deviceFile.getCanonicalPath();
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to get disk name for " + majorMinor, new Object[0]);
            }
            finally {
                if (this.diskName == null) {
                    this.diskName = majorMinor;
                }
            }
        }

        public long getReadCount() {
            return this.readCount;
        }

        public long getWriteCount() {
            return this.writeCount;
        }

        public long getReadBytes() {
            return this.readBytes;
        }

        public long getWriteBytes() {
            return this.writeBytes;
        }

        public String getDiskName() {
            return this.diskName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metrics metrics = (Metrics)o;
            return this.readCount == metrics.readCount && this.writeCount == metrics.writeCount && this.readBytes == metrics.readBytes && this.writeBytes == metrics.writeBytes && Objects.equals(this.diskName, metrics.diskName);
        }

        public int hashCode() {
            return Objects.hash(this.diskName, this.readCount, this.writeCount, this.readBytes, this.writeBytes);
        }
    }
}

