/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.druid.java.util.common.guava.MergeIterator;

public class MergeIterable<T>
implements Iterable<T> {
    private final Comparator<? super T> comparator;
    private final Iterable<? extends Iterable<? extends T>> baseIterables;

    public MergeIterable(Iterable<? extends Iterable<? extends T>> baseIterables, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.baseIterables = baseIterables;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>();
        for (Iterable<T> baseIterable : this.baseIterables) {
            iterators.add(baseIterable.iterator());
        }
        return new MergeIterator<T>(iterators, this.comparator);
    }
}

