/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.net.HostAndPort;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;

public class TaskLocation {
    private static final TaskLocation UNKNOWN = new TaskLocation(null, -1, -1, null);
    @Nullable
    private final String host;
    private final int port;
    private final int tlsPort;
    @Nullable
    private final String k8sPodName;

    public static TaskLocation create(String host, int port, int tlsPort) {
        return new TaskLocation(host, port, tlsPort, null);
    }

    public static TaskLocation create(String host, int port, int tlsPort, boolean isTls) {
        return TaskLocation.create(host, port, tlsPort, isTls, null);
    }

    public static TaskLocation create(String host, int port, int tlsPort, boolean isTls, @Nullable String k8sPodName) {
        return isTls ? new TaskLocation(host, -1, tlsPort, k8sPodName) : new TaskLocation(host, port, -1, k8sPodName);
    }

    public static TaskLocation unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public TaskLocation(@JsonProperty(value="host") @Nullable String host, @JsonProperty(value="port") int port, @JsonProperty(value="tlsPort") int tlsPort, @JsonProperty(value="k8sPodName") @Nullable String k8sPodName) {
        this.host = host;
        this.port = port;
        this.tlsPort = tlsPort;
        this.k8sPodName = k8sPodName;
    }

    @Nullable
    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public int getTlsPort() {
        return this.tlsPort;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public String getK8sPodName() {
        return this.k8sPodName;
    }

    @JsonIgnore
    @Nullable
    public String getLocation() {
        if (this.k8sPodName != null) {
            return this.k8sPodName;
        }
        if (this.host == null) {
            return null;
        }
        int thePort = this.tlsPort >= 0 ? this.tlsPort : this.port;
        return HostAndPort.fromParts((String)this.host, (int)thePort).toString();
    }

    public URL makeURL(String encodedPathAndQueryString) throws MalformedURLException {
        int portToUse;
        String scheme;
        if (this.tlsPort > 0) {
            scheme = "https";
            portToUse = this.tlsPort;
        } else {
            scheme = "http";
            portToUse = this.port;
        }
        if (!encodedPathAndQueryString.startsWith("/")) {
            throw new IAE("Path must start with '/'", new Object[0]);
        }
        return new URL(scheme, this.host, portToUse, encodedPathAndQueryString);
    }

    public String toString() {
        return "TaskLocation{host='" + this.host + '\'' + ", port=" + this.port + ", tlsPort=" + this.tlsPort + ", k8sPodName=" + this.k8sPodName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLocation that = (TaskLocation)o;
        return this.port == that.port && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host) && Objects.equals(this.k8sPodName, that.k8sPodName);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.tlsPort, this.k8sPodName);
    }
}

