/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

public class Property<T> {
    private final String name;
    @Nullable
    private final T value;

    public Property(String name, @Nullable T value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public boolean isValueNullOrEmptyCollection() {
        if (this.value == null) {
            return true;
        }
        if (this.value instanceof Collection) {
            return ((Collection)this.value).isEmpty();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return Objects.equals(this.name, property.name) && Objects.equals(this.value, property.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "Property{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

