/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.write.columnar.DoubleFrameMaker;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.DoubleColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    DoubleFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        DoubleFrameColumn frameCol = this.makeDoubleFrameColumn(frame);
        return new ColumnAccessorBasedColumn(frameCol);
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        DoubleFrameColumn frameCol = this.makeDoubleFrameColumn(frame);
        return new ColumnPlus(frameCol, ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(frameCol.getType()).setHasNulls(NullHandling.sqlCompatible() && frameCol.hasNulls), frame.numRows());
    }

    @Nonnull
    private DoubleFrameColumn makeDoubleFrameColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory, frame.numRows());
        boolean hasNulls = DoubleFrameColumnReader.getHasNulls(memory);
        return new DoubleFrameColumn(frame, hasNulls, memory);
    }

    private void validate(Memory region, int numRows) {
        long memorySize = region.getCapacity();
        if (memorySize < 2L) {
            throw new ISE("Column is not big enough for a header", new Object[0]);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 3) {
            throw new ISE("Column does not have the correct type code", new Object[0]);
        }
        boolean hasNulls = DoubleFrameColumnReader.getHasNulls(region);
        int sz = DoubleFrameMaker.valueSize(hasNulls);
        if (memorySize != 2L + (long)sz * (long)numRows) {
            throw new ISE("Column does not have the correct length", new Object[0]);
        }
    }

    private static boolean getHasNulls(Memory memory) {
        return memory.getByte(1L) != 0;
    }

    private static class DoubleFrameColumn
    extends DoubleColumnAccessorBase
    implements NumericColumn {
        private final Frame frame;
        private final boolean hasNulls;
        private final int sz;
        private final Memory memory;
        private final long memoryPosition;

        private DoubleFrameColumn(Frame frame, boolean hasNulls, Memory memory) {
            this.frame = frame;
            this.hasNulls = hasNulls;
            this.sz = DoubleFrameMaker.valueSize(hasNulls);
            this.memory = memory;
            this.memoryPosition = 2L;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new DoubleColumnSelector(){

                @Override
                public double getDouble() {
                    assert (NullHandling.replaceWithDefault() || !this.isNull());
                    return this.getDoublePhysical(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public boolean isNull() {
                    return this.isNullPhysical(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(final ReadableVectorOffset theOffset) {
            class DoubleFrameColumnVectorValueSelector
            extends BaseDoubleVectorValueSelector {
                private final double[] doubleVector;
                private final boolean[] nullVector;
                private int id;

                DoubleFrameColumnVectorValueSelector() {
                    super(readableVectorOffset);
                    this.id = -1;
                    this.doubleVector = new double[this.offset.getMaxVectorSize()];
                    this.nullVector = DoubleFrameColumn.this.hasNulls ? new boolean[this.offset.getMaxVectorSize()] : null;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                @Override
                public double[] getDoubleVector() {
                    this.computeVectorsIfNeeded();
                    return this.doubleVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    if (this.offset.isContiguous()) {
                        int start = this.offset.getStartOffset();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = DoubleFrameColumn.this.frame.physicalRow(i + start);
                            this.doubleVector[i] = DoubleFrameColumn.this.getDoublePhysical(physicalRow);
                            if (!DoubleFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = DoubleFrameColumn.this.isNullPhysical(physicalRow);
                        }
                    } else {
                        int[] offsets = this.offset.getOffsets();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = DoubleFrameColumn.this.frame.physicalRow(offsets[i]);
                            this.doubleVector[i] = DoubleFrameColumn.this.getDoublePhysical(physicalRow);
                            if (!DoubleFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = DoubleFrameColumn.this.isNullPhysical(physicalRow);
                        }
                    }
                    this.id = this.offset.getId();
                }
            }
            return new DoubleFrameColumnVectorValueSelector();
        }

        @Override
        public int length() {
            return this.frame.numRows();
        }

        @Override
        public long getLongSingleValueRow(int rowNum) {
            if (rowNum < 0 || rowNum >= this.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", rowNum);
            }
            return (long)this.getDoublePhysical(this.frame.physicalRow(rowNum));
        }

        @Override
        public void close() {
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public int numRows() {
            return this.length();
        }

        @Override
        public boolean isNull(int rowNum) {
            return this.isNullPhysical(this.frame.physicalRow(rowNum));
        }

        @Override
        public double getDouble(int rowNum) {
            return this.getDoublePhysical(this.frame.physicalRow(rowNum));
        }

        private boolean isNullPhysical(int physicalRow) {
            if (this.hasNulls) {
                long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
                return this.memory.getByte(rowPosition) != 0;
            }
            return false;
        }

        private double getDoublePhysical(int physicalRow) {
            long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
            if (this.hasNulls) {
                return this.memory.getDouble(rowPosition + 1L);
            }
            return this.memory.getDouble(rowPosition);
        }
    }
}

