/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;

public class FrameFileFooter {
    private final Memory footerMemory;
    private final int numFrames;
    private final int numPartitions;
    private final long frameFileLength;

    public FrameFileFooter(Memory footerMemory, long frameFileLength) throws IOE {
        this.footerMemory = footerMemory;
        this.frameFileLength = frameFileLength;
        Memory trailer = footerMemory.region(footerMemory.getCapacity() - 16L, 16L, ByteOrder.LITTLE_ENDIAN);
        this.numFrames = trailer.getInt(0L);
        this.numPartitions = trailer.getInt(4L);
        int length = trailer.getInt(8L);
        int expectedFooterChecksum = trailer.getInt(12L);
        if (footerMemory.getByte(0L) != 2) {
            throw new IOE("File [%s] end marker not in expected location", "file");
        }
        int actualChecksum = (int)footerMemory.xxHash64(0L, footerMemory.getCapacity() - 4L, 0L);
        if (expectedFooterChecksum != actualChecksum) {
            throw new ISE("Expected footer checksum did not match actual checksum. Corrupt or truncated file?", new Object[0]);
        }
        if (length != FrameFileWriter.footerLength(this.numFrames, this.numPartitions)) {
            throw new ISE("Expected footer length did not match actual footer length. Corrupt or truncated file?", new Object[0]);
        }
    }

    public int getPartitionStartFrame(int partition) {
        if (partition < 0) {
            throw new IAE("Partition [%,d] out of bounds", partition);
        }
        if (partition >= this.numPartitions) {
            return this.numFrames;
        }
        long partitionStartFrameLocation = this.footerMemory.getCapacity() - 16L - (long)this.numFrames * 8L - (long)(this.numPartitions - partition) * 4L;
        return this.footerMemory.getInt(partitionStartFrameLocation);
    }

    public long getFrameEndPosition(int frameNumber) {
        assert (frameNumber >= 0 && frameNumber < this.numFrames);
        long frameEndPointerPosition = this.footerMemory.getCapacity() - 16L - (long)(this.numFrames - frameNumber) * 8L;
        long frameEndPosition = this.footerMemory.getLong(frameEndPointerPosition);
        if (frameEndPosition < 0L || frameEndPosition > this.frameFileLength - this.footerMemory.getCapacity()) {
            throw new ISE("Corrupt frame file: frame [%,d] location out of range", frameNumber);
        }
        return frameEndPosition;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }
}

