/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DelimitedValueReader;
import org.apache.druid.data.input.impl.FlatTextInputFormat;
import org.apache.druid.java.util.common.StringUtils;

public class CsvInputFormat
extends FlatTextInputFormat {
    public static final String TYPE_KEY = "csv";
    private static final char SEPARATOR = ',';

    @JsonCreator
    public CsvInputFormat(@JsonProperty(value="columns") @Nullable List<String> columns, @JsonProperty(value="listDelimiter") @Nullable String listDelimiter, @Deprecated @JsonProperty(value="hasHeaderRow") @Nullable Boolean hasHeaderRow, @JsonProperty(value="findColumnsFromHeader") @Nullable Boolean findColumnsFromHeader, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(columns, listDelimiter, String.valueOf(','), hasHeaderRow, findColumnsFromHeader, skipHeaderRows);
    }

    @Override
    @JsonIgnore
    public String getDelimiter() {
        return super.getDelimiter();
    }

    @Override
    @JsonIgnore
    public boolean isSplittable() {
        return true;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        RFC4180Parser parser = CsvInputFormat.createOpenCsvParser();
        return new DelimitedValueReader(inputRowSchema, source, this.getListDelimiter(), this.getColumns(), this.isFindColumnsFromHeader(), this.getSkipHeaderRows(), line -> Arrays.asList(parser.parseLine(StringUtils.fromUtf8(line))), this.useListBasedInputRows());
    }

    public static RFC4180Parser createOpenCsvParser() {
        return NullHandling.replaceWithDefault() ? new RFC4180ParserBuilder().withSeparator(',').build() : new RFC4180ParserBuilder().withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).withSeparator(',').build();
    }

    public String toString() {
        return "CsvInputFormat{" + this.fieldsToString() + "}";
    }
}

