/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;

public class GuavaUtils {
    private static final Logger log = new Logger(GuavaUtils.class);

    @Nullable
    public static Long tryParseLong(@Nullable String string) {
        return Strings.isNullOrEmpty((String)string) ? null : Longs.tryParse((String)(string.charAt(0) == '+' ? string.substring(1) : string));
    }

    @Nullable
    public static <T extends Enum<T>> T getEnumIfPresent(Class<T> enumClass, String value) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (!enumValue.name().equals(value)) continue;
            return (T)enumValue;
        }
        return null;
    }

    @Nullable
    public static <T> T firstNonNull(@Nullable T lhs, @Nullable T rhs) {
        if (lhs == null) {
            return rhs;
        }
        return lhs;
    }

    public static <F extends Future<?>> void cancelAll(boolean mayInterruptIfRunning, @Nullable Future<?> combinedFuture, List<F> futures) {
        ArrayList<Future<Object>> allFuturesToCancel = new ArrayList<Future<Object>>();
        allFuturesToCancel.add(combinedFuture);
        allFuturesToCancel.addAll(futures);
        if (allFuturesToCancel.isEmpty()) {
            return;
        }
        allFuturesToCancel.forEach(f -> {
            try {
                if (f != null) {
                    f.cancel(mayInterruptIfRunning);
                }
            }
            catch (Throwable t) {
                log.warn(t, "Error while cancelling future.", new Object[0]);
            }
        });
    }
}

