
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

import javax.inject.Inject;

/*
 * This class is generated using freemarker and the CastFunctionsTargetVarLen.java template.
 */
@SuppressWarnings("unused")
@FunctionTemplate(name = "castVARCHAR",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.STRING_CAST,
    nulls = NullHandling.NULL_IF_NULL)
public class CastFloat4VarChar implements DrillSimpleFunc{

  @Param Float4Holder in;
  @Param BigIntHolder len;
  @Inject DrillBuf buffer;     
  @Output VarCharHolder out;

  public void setup() {
  }

  public void eval() {
    buffer = buffer.reallocIfNeeded((int)len.value);
    String istr = (new Float(in.value)).toString();
    out.buffer = buffer;
    out.start = 0;
    out.end = Math.min((int)len.value, istr.length()); // truncate if target type has length smaller than that of input's string
    out.buffer.setBytes(0, istr.substring(0,out.end).getBytes(java.nio.charset.StandardCharsets.UTF_8));
  }
}

 

