
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkArgument;
import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkState;

import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import io.netty.buffer.ByteBuf;

/*
 * This class is generated using freemarker and the Decimal/DecimalAggrTypeFunctions1.java template.
 */

@SuppressWarnings("unused")

public class DecimalMaxFunctions {


  @FunctionTemplate(name = "max",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
  public static class VarDecimalMax implements DrillAggFunc {
    @Param VarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace IntHolder scale;
    @Workspace IntHolder precision;
    @Workspace ObjectHolder tempResult;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;
    @Inject DrillBuf buf;

    public void setup() {
      tempResult = new ObjectHolder();
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {
      nonNullCount.value = 1;
      org.apache.drill.exec.expr.fn.impl.DrillByteArray tmp = (org.apache.drill.exec.expr.fn.impl.DrillByteArray) tempResult.obj;
      int cmp = 0;
      if (tmp != null) {
        cmp = org.apache.drill.exec.util.DecimalUtility
            .compareVarLenBytes(in.buffer, in.start, in.end, in.scale,
                tmp.getBytes(), scale.value, false);
      } else {
        cmp = 1;
        tmp = new org.apache.drill.exec.expr.fn.impl.DrillByteArray();
        tempResult.obj = tmp;
      }

      if (cmp > 0) {
        int inputLength = in.end - in.start;
        if (tmp.getLength() >= inputLength) {
          in.buffer.getBytes(in.start, tmp.getBytes(), 0, inputLength);
          tmp.setLength(inputLength);
        } else {
          byte[] tempArray = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, tempArray, 0, in.end - in.start);
          tmp.setBytes(tempArray);
        }
        scale.value = in.scale;
        precision.value = in.precision;
      }
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        org.apache.drill.exec.expr.fn.impl.DrillByteArray tmp = (org.apache.drill.exec.expr.fn.impl.DrillByteArray) tempResult.obj;
        buf = buf.reallocIfNeeded(tmp.getLength());
        buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
        out.start = 0;
        out.end = tmp.getLength();
        out.buffer = buf;

        out.scale = scale.value;
        out.precision = precision.value;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      scale.value = 0;
      precision.value = 0;
      tempResult.obj = null;
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "max",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
  public static class NullableVarDecimalMax implements DrillAggFunc {
    @Param NullableVarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace IntHolder scale;
    @Workspace IntHolder precision;
    @Workspace ObjectHolder tempResult;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;
    @Inject DrillBuf buf;

    public void setup() {
      tempResult = new ObjectHolder();
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {
      sout: {
      if (in.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }
      nonNullCount.value = 1;
      org.apache.drill.exec.expr.fn.impl.DrillByteArray tmp = (org.apache.drill.exec.expr.fn.impl.DrillByteArray) tempResult.obj;
      int cmp = 0;
      if (tmp != null) {
        cmp = org.apache.drill.exec.util.DecimalUtility
            .compareVarLenBytes(in.buffer, in.start, in.end, in.scale,
                tmp.getBytes(), scale.value, false);
      } else {
        cmp = 1;
        tmp = new org.apache.drill.exec.expr.fn.impl.DrillByteArray();
        tempResult.obj = tmp;
      }

      if (cmp > 0) {
        int inputLength = in.end - in.start;
        if (tmp.getLength() >= inputLength) {
          in.buffer.getBytes(in.start, tmp.getBytes(), 0, inputLength);
          tmp.setLength(inputLength);
        } else {
          byte[] tempArray = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, tempArray, 0, in.end - in.start);
          tmp.setBytes(tempArray);
        }
        scale.value = in.scale;
        precision.value = in.precision;
      }
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        org.apache.drill.exec.expr.fn.impl.DrillByteArray tmp = (org.apache.drill.exec.expr.fn.impl.DrillByteArray) tempResult.obj;
        buf = buf.reallocIfNeeded(tmp.getLength());
        buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
        out.start = 0;
        out.end = tmp.getLength();
        out.buffer = buf;

        out.scale = scale.value;
        out.precision = precision.value;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      scale.value = 0;
      precision.value = 0;
      tempResult.obj = null;
      nonNullCount.value = 0;
    }
  }
}
