/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.kudu.KuduSubScan;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(KuduRecordReader.class);
    private static final int TARGET_RECORD_COUNT = 4000;
    private final KuduClient client;
    private final KuduSubScan.KuduSubScanSpec scanSpec;
    private KuduScanner scanner;
    private RowResultIterator iterator;
    private OutputMutator output;
    private OperatorContext context;
    private String lastColumnName;
    private Type lastColumnType;
    private ImmutableList<ProjectedColumnInfo> projectedCols;
    static final Map<Type, TypeProtos.MinorType> TYPES = ImmutableMap.builder().put((Object)Type.BINARY, (Object)TypeProtos.MinorType.VARBINARY).put((Object)Type.BOOL, (Object)TypeProtos.MinorType.BIT).put((Object)Type.DOUBLE, (Object)TypeProtos.MinorType.FLOAT8).put((Object)Type.FLOAT, (Object)TypeProtos.MinorType.FLOAT4).put((Object)Type.INT8, (Object)TypeProtos.MinorType.INT).put((Object)Type.INT16, (Object)TypeProtos.MinorType.INT).put((Object)Type.INT32, (Object)TypeProtos.MinorType.INT).put((Object)Type.INT64, (Object)TypeProtos.MinorType.BIGINT).put((Object)Type.STRING, (Object)TypeProtos.MinorType.VARCHAR).put((Object)Type.UNIXTIME_MICROS, (Object)TypeProtos.MinorType.TIMESTAMP).build();

    public KuduRecordReader(KuduClient client, KuduSubScan.KuduSubScanSpec subScanSpec, List<SchemaPath> projectedColumns) {
        this.setColumns(projectedColumns);
        this.client = client;
        this.scanSpec = subScanSpec;
        logger.debug("Scan spec: {}", (Object)subScanSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        this.output = output;
        this.context = context;
        try {
            KuduTable table = this.client.openTable(this.scanSpec.getTableName());
            KuduScanner.KuduScannerBuilder builder = this.client.newScannerBuilder(table);
            if (!this.isStarQuery()) {
                ArrayList colNames = Lists.newArrayList();
                for (SchemaPath p : this.getColumns()) {
                    colNames.add(p.getRootSegmentPath());
                }
                builder.setProjectedColumnNames((List)colNames);
            }
            context.getStats().startWait();
            try {
                this.scanner = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)builder.lowerBoundRaw(this.scanSpec.getStartKey())).exclusiveUpperBoundRaw(this.scanSpec.getEndKey())).build();
            }
            finally {
                context.getStats().stopWait();
            }
        }
        catch (Exception e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int next() {
        int rowCount = 0;
        try {
            while (this.iterator == null || !this.iterator.hasNext()) {
                if (!this.scanner.hasMoreRows()) {
                    this.iterator = null;
                    return 0;
                }
                this.context.getStats().startWait();
                try {
                    this.iterator = this.scanner.nextRows();
                }
                finally {
                    this.context.getStats().stopWait();
                }
            }
            while (rowCount < 4000 && this.iterator.hasNext()) {
                this.addRowResult((RowResult)this.iterator.next(), rowCount);
                ++rowCount;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (ProjectedColumnInfo pci : this.projectedCols) {
            pci.vv.getMutator().setValueCount(rowCount);
        }
        return rowCount;
    }

    private void initCols(Schema schema) throws SchemaChangeException {
        ImmutableList.Builder pciBuilder = ImmutableList.builder();
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            ColumnSchema col = schema.getColumnByIndex(i);
            String name = col.getName();
            Type kuduType = col.getType();
            this.lastColumnName = name;
            this.lastColumnType = kuduType;
            TypeProtos.MinorType minorType = TYPES.get(kuduType);
            if (minorType == null) {
                logger.warn("Ignoring column that is unsupported.", (Throwable)UserException.unsupportedError().message("A column you queried has a data type that is not currently supported by the Kudu storage plugin. The column's name was %s and its Kudu data type was %s. ", new Object[]{name, kuduType.toString()}).addContext("column Name", name).addContext("plugin", "kudu").build(logger));
                continue;
            }
            TypeProtos.MajorType majorType = col.isNullable() ? Types.optional((TypeProtos.MinorType)minorType) : Types.required((TypeProtos.MinorType)minorType);
            MaterializedField field = MaterializedField.create((String)name, (TypeProtos.MajorType)majorType);
            Class clazz = TypeHelper.getValueVectorClass((TypeProtos.MinorType)minorType, (TypeProtos.DataMode)majorType.getMode());
            ValueVector vector = this.output.addField(field, clazz);
            vector.allocateNew();
            ProjectedColumnInfo pci = new ProjectedColumnInfo();
            pci.vv = vector;
            pci.kuduColumn = col;
            pci.index = i;
            pciBuilder.add((Object)pci);
        }
        this.projectedCols = pciBuilder.build();
    }

    private void addRowResult(RowResult result, int rowIndex) throws SchemaChangeException {
        if (this.projectedCols == null) {
            this.initCols(result.getColumnProjection());
        }
        block12: for (ProjectedColumnInfo pci : this.projectedCols) {
            if (result.isNull(pci.index)) continue;
            switch (pci.kuduColumn.getType()) {
                case BINARY: {
                    ByteBuffer value = result.getBinary(pci.index);
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableVarBinaryVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, value, 0, value.remaining());
                        continue block12;
                    }
                    ((VarBinaryVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, value, 0, value.remaining());
                    continue block12;
                }
                case STRING: {
                    ByteBuffer value = ByteBuffer.wrap(result.getString(pci.index).getBytes(StandardCharsets.UTF_8));
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableVarCharVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, value, 0, value.remaining());
                        continue block12;
                    }
                    ((VarCharVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, value, 0, value.remaining());
                    continue block12;
                }
                case BOOL: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableBitVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getBoolean(pci.index) ? 1 : 0);
                        continue block12;
                    }
                    ((BitVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getBoolean(pci.index) ? 1 : 0);
                    continue block12;
                }
                case DOUBLE: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableFloat8Vector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getDouble(pci.index));
                        continue block12;
                    }
                    ((Float8Vector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getDouble(pci.index));
                    continue block12;
                }
                case FLOAT: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableFloat4Vector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getFloat(pci.index));
                        continue block12;
                    }
                    ((Float4Vector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getFloat(pci.index));
                    continue block12;
                }
                case INT16: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableIntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, (int)result.getShort(pci.index));
                        continue block12;
                    }
                    ((IntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, (int)result.getShort(pci.index));
                    continue block12;
                }
                case INT32: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableIntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getInt(pci.index));
                        continue block12;
                    }
                    ((IntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getInt(pci.index));
                    continue block12;
                }
                case INT8: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableIntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, (int)result.getByte(pci.index));
                        continue block12;
                    }
                    ((IntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, (int)result.getByte(pci.index));
                    continue block12;
                }
                case INT64: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableBigIntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getLong(pci.index));
                        continue block12;
                    }
                    ((BigIntVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getLong(pci.index));
                    continue block12;
                }
                case UNIXTIME_MICROS: {
                    if (pci.kuduColumn.isNullable()) {
                        ((NullableTimeStampVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getLong(pci.index) / 1000L);
                        continue block12;
                    }
                    ((TimeStampVector.Mutator)pci.vv.getMutator()).setSafe(rowIndex, result.getLong(pci.index) / 1000L);
                    continue block12;
                }
            }
            throw new SchemaChangeException("unknown type");
        }
    }

    public void close() {
    }

    public String toString() {
        return "KuduRecordReader[Column=" + this.lastColumnName + ", Type=" + this.lastColumnType + "]";
    }

    private static class ProjectedColumnInfo {
        int index;
        ValueVector vv;
        ColumnSchema kuduColumn;

        private ProjectedColumnInfo() {
        }
    }
}

