/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.util;

import io.github.toolfactory.jvm.function.template.Consumer;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.function.util.BufferHandler;
import io.github.toolfactory.jvm.function.util.Classes;
import java.nio.ByteBuffer;

public class JavaClass {
    private String classNameSlashed;
    private String className;

    private JavaClass(String className, ByteBuffer byteCode) {
        this.classNameSlashed = className;
    }

    private JavaClass(ByteBuffer byteCode) {
        this(Classes.retrieveName(byteCode), BufferHandler.shareContent(byteCode));
    }

    public static JavaClass create(ByteBuffer byteCode) {
        return new JavaClass(byteCode);
    }

    public static void use(ByteBuffer byteCode, Consumer<JavaClass> javaClassConsumer) {
        javaClassConsumer.accept(JavaClass.create(byteCode));
    }

    public static <T, E extends Throwable> T extractByUsing(ByteBuffer byteCode, Function<JavaClass, T> javaClassConsumer) throws E {
        return javaClassConsumer.apply(JavaClass.create(byteCode));
    }

    private String _getPackageName() {
        return this.classNameSlashed.contains("/") ? this.classNameSlashed.substring(0, this.classNameSlashed.lastIndexOf("/")) : null;
    }

    private String _getSimpleName() {
        return this.classNameSlashed.contains("/") ? this.classNameSlashed.substring(this.classNameSlashed.lastIndexOf("/") + 1) : this.classNameSlashed;
    }

    public String getPackageName() {
        String pckgName = this._getPackageName();
        if (pckgName != null) {
            pckgName = pckgName.replace("/", ".");
        }
        return pckgName;
    }

    public String getSimpleName() {
        return this._getSimpleName();
    }

    public String getName() {
        if (this.className == null) {
            String packageName = this.getPackageName();
            String classSimpleName = this.getSimpleName();
            String name = null;
            if (packageName != null) {
                name = packageName;
            }
            if (classSimpleName != null) {
                name = packageName == null ? "" : name + ".";
                name = name + classSimpleName;
            }
            this.className = name;
        }
        return this.className;
    }
}

