/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Function;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOperation
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(CopyOperation.class);
    private final ObjectStorage client;
    private final GetObjectRequest getRequest;
    private final Function<GetObjectResponse, PutObjectRequest> putRequestFn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        GetObjectResponse getResponse = this.client.getObject(this.getRequest);
        try {
            LOG.debug("Attempting to copy source object with eTag {}", (Object)getResponse.getETag());
            PutObjectRequest putRequest = (PutObjectRequest)this.putRequestFn.apply((Object)getResponse);
            PutObjectResponse putResponse = this.client.putObject(putRequest);
            String string = putResponse.getETag();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)getResponse.getInputStream());
        }
    }

    @ConstructorProperties(value={"client", "getRequest", "putRequestFn"})
    public CopyOperation(ObjectStorage client, GetObjectRequest getRequest, Function<GetObjectResponse, PutObjectRequest> putRequestFn) {
        this.client = client;
        this.getRequest = getRequest;
        this.putRequestFn = putRequestFn;
    }
}

