/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.hdfs.BmcConstants;
import com.oracle.bmc.hdfs.BmcProperties;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcPropertyAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(BmcPropertyAccessor.class);
    private final Configuration configuration;
    private final String propertyOverrideSuffix;

    String get(String property) {
        return this.configuration.get(property);
    }

    private String getOverriddenPropertyName(BmcProperties property) {
        return property.getPropertyName() + this.propertyOverrideSuffix;
    }

    public Accessor<Boolean> asBoolean() {
        return new Accessor<Boolean>(){

            @Override
            public Boolean get(BmcProperties property) {
                String overriddenPropertyName = BmcPropertyAccessor.this.getOverriddenPropertyName(property);
                if (BmcPropertyAccessor.this.exists(overriddenPropertyName)) {
                    LOG.debug("Using key {}", (Object)overriddenPropertyName);
                    return BmcPropertyAccessor.this.configuration.getBoolean(overriddenPropertyName, false);
                }
                BmcPropertyAccessor.this.checkClash(property);
                if (BmcPropertyAccessor.this.exists(property.getPropertyName())) {
                    LOG.debug("Using key {}", (Object)property.getPropertyName());
                    return BmcPropertyAccessor.this.configuration.getBoolean(property.getPropertyName(), false);
                }
                String deprecatedKey = BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName());
                if (BmcPropertyAccessor.this.exists(deprecatedKey)) {
                    LOG.debug("Using key {}", (Object)deprecatedKey);
                    return BmcPropertyAccessor.this.configuration.getBoolean(deprecatedKey, false);
                }
                LOG.debug("No configuration found for {}", (Object)property.getPropertyName());
                return (Boolean)property.getDefaultValue();
            }
        };
    }

    public Accessor<Integer> asInteger() {
        return new Accessor<Integer>(){

            @Override
            public Integer get(BmcProperties property) {
                String overriddenPropertyName = BmcPropertyAccessor.this.getOverriddenPropertyName(property);
                if (BmcPropertyAccessor.this.exists(overriddenPropertyName)) {
                    LOG.debug("Using key {}", (Object)overriddenPropertyName);
                    return BmcPropertyAccessor.this.configuration.getInt(overriddenPropertyName, 0);
                }
                BmcPropertyAccessor.this.checkClash(property);
                if (BmcPropertyAccessor.this.exists(property.getPropertyName())) {
                    LOG.debug("Using key {}", (Object)property.getPropertyName());
                    return BmcPropertyAccessor.this.configuration.getInt(property.getPropertyName(), 0);
                }
                String deprecatedKey = BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName());
                if (BmcPropertyAccessor.this.exists(deprecatedKey)) {
                    LOG.debug("Using key {}", (Object)deprecatedKey);
                    return BmcPropertyAccessor.this.configuration.getInt(deprecatedKey, 0);
                }
                LOG.debug("No configuration found for {}", (Object)property.getPropertyName());
                return (Integer)property.getDefaultValue();
            }
        };
    }

    public Accessor<String> asString() {
        return new Accessor<String>(){

            @Override
            public String get(BmcProperties property) {
                String overriddenPropertyName = BmcPropertyAccessor.this.getOverriddenPropertyName(property);
                if (BmcPropertyAccessor.this.exists(overriddenPropertyName)) {
                    LOG.debug("Using key {}", (Object)overriddenPropertyName);
                    return BmcPropertyAccessor.this.configuration.getTrimmed(overriddenPropertyName, null);
                }
                BmcPropertyAccessor.this.checkClash(property);
                if (BmcPropertyAccessor.this.exists(property.getPropertyName())) {
                    LOG.debug("Using key {}", (Object)property.getPropertyName());
                    return BmcPropertyAccessor.this.configuration.getTrimmed(property.getPropertyName(), null);
                }
                String deprecatedKey = BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName());
                if (BmcPropertyAccessor.this.exists(deprecatedKey)) {
                    LOG.debug("Using key {}", (Object)deprecatedKey);
                    return BmcPropertyAccessor.this.configuration.getTrimmed(deprecatedKey, null);
                }
                LOG.debug("No configuration found for {}", (Object)property.getPropertyName());
                return (String)property.getDefaultValue();
            }
        };
    }

    public Accessor<char[]> asPassword() {
        return new Accessor<char[]>(){

            @Override
            public char[] get(BmcProperties property) {
                try {
                    String overriddenPropertyName = BmcPropertyAccessor.this.getOverriddenPropertyName(property);
                    char[] overriddenPassword = BmcPropertyAccessor.this.configuration.getPassword(overriddenPropertyName);
                    if (overriddenPassword != null) {
                        LOG.debug("Using key {}", (Object)overriddenPropertyName);
                        return overriddenPassword;
                    }
                    char[] password = BmcPropertyAccessor.this.configuration.getPassword(property.getPropertyName());
                    String deprecatedKey = BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName());
                    char[] deprecatedPassword = BmcPropertyAccessor.this.configuration.getPassword(deprecatedKey);
                    if (password != null && deprecatedPassword != null) {
                        BmcPropertyAccessor.this.throwClash(property);
                    }
                    if (password != null) {
                        LOG.debug("Using key {}", (Object)property.getPropertyName());
                        return password;
                    }
                    if (deprecatedPassword != null) {
                        LOG.debug("Using key {}", (Object)deprecatedKey);
                        return deprecatedPassword;
                    }
                    LOG.debug("No configuration found for {}", (Object)property.getPropertyName());
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to extract password", e);
                }
            }
        };
    }

    public Accessor<Long> asLong() {
        return new Accessor<Long>(){

            @Override
            public Long get(BmcProperties property) {
                String overriddenPropertyName = BmcPropertyAccessor.this.getOverriddenPropertyName(property);
                if (BmcPropertyAccessor.this.exists(overriddenPropertyName)) {
                    LOG.debug("Using key {}", (Object)overriddenPropertyName);
                    return BmcPropertyAccessor.this.configuration.getLong(overriddenPropertyName, 0L);
                }
                BmcPropertyAccessor.this.checkClash(property);
                if (BmcPropertyAccessor.this.exists(property.getPropertyName())) {
                    LOG.debug("Using key {}", (Object)property.getPropertyName());
                    return BmcPropertyAccessor.this.configuration.getLong(property.getPropertyName(), 0L);
                }
                String deprecatedKey = BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName());
                if (BmcPropertyAccessor.this.exists(deprecatedKey)) {
                    LOG.debug("Using key {}", (Object)deprecatedKey);
                    return BmcPropertyAccessor.this.configuration.getLong(deprecatedKey, 0L);
                }
                LOG.debug("No configuration found for {}", (Object)property.getPropertyName());
                return (Long)property.getDefaultValue();
            }
        };
    }

    private boolean exists(String key) {
        return this.get(key) != null;
    }

    private void checkClash(BmcProperties property) {
        if (this.clashes(property)) {
            this.throwClash(property);
        }
    }

    private void throwClash(BmcProperties property) {
        throw new IllegalArgumentException("Configuration uses both " + property.getPropertyName() + " and the deprecated key " + BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName()) + ". Use one or the other, but not both.");
    }

    private boolean clashes(BmcProperties property) {
        return this.get(property.getPropertyName()) != null && this.get(BmcConstants.Deprecated.getDeprecatedKey(property.getPropertyName())) != null;
    }

    @ConstructorProperties(value={"configuration", "propertyOverrideSuffix"})
    public BmcPropertyAccessor(Configuration configuration, String propertyOverrideSuffix) {
        this.configuration = configuration;
        this.propertyOverrideSuffix = propertyOverrideSuffix;
    }

    public static interface Accessor<T> {
        public T get(BmcProperties var1);

        default public <R> R forNonNull(BmcProperties property, Function<T, R> fn) {
            T value = this.get(property);
            if (value != null) {
                return fn.apply(value);
            }
            return null;
        }
    }
}

