/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.auth;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.internal.EnvironmentRptPathProvider;
import com.oracle.bmc.auth.internal.RptPathProvider;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class ResourcePrincipalsCustomAuthenticator
implements BasicAuthenticationDetailsProvider,
RegionProvider,
RefreshableOnNotAuthenticatedProvider<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalsCustomAuthenticator.class);
    static final String OCI_RESOURCE_PRINCIPAL_VERSION = "OCI_RESOURCE_PRINCIPAL_VERSION";
    private static final String RP_VERSION_1_1 = "1.1";
    private ResourcePrincipalAuthenticationDetailsProvider provider;

    public ResourcePrincipalsCustomAuthenticator(Configuration conf) {
        String resourcePrincipalVersion = System.getenv(OCI_RESOURCE_PRINCIPAL_VERSION);
        if (resourcePrincipalVersion == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION environment variable missing");
        }
        LOG.info("ResourcePrincipalsCustomAuthenticator is using resource principal version " + resourcePrincipalVersion);
        this.provider = resourcePrincipalVersion.equals(RP_VERSION_1_1) ? ResourcePrincipalAuthenticationDetailsProvider.builder().resourcePrincipalTokenPathProvider((RptPathProvider)new EnvironmentRptPathProvider()).build() : ResourcePrincipalAuthenticationDetailsProvider.builder().build();
    }

    public String refresh() {
        return this.provider.refresh();
    }

    public Region getRegion() {
        return this.provider.getRegion();
    }

    public String getKeyId() {
        return this.provider.getKeyId();
    }

    public InputStream getPrivateKey() {
        return this.provider.getPrivateKey();
    }

    public String getPassPhrase() {
        return this.provider.getPassPhrase();
    }

    public char[] getPassphraseCharacters() {
        return this.provider.getPassphraseCharacters();
    }
}

